/* 
/ freexl.h
/
/ public declarations
/
/ version  1.0, 2011 July 26
/
/ Author: Sandro Furieri a.furieri@lqt.it
/
/ ------------------------------------------------------------------------------
/ 
/ Version: MPL 1.1/GPL 2.0/LGPL 2.1
/ 
/ The contents of this file are subject to the Mozilla Public License Version
/ 1.1 (the "License"); you may not use this file except in compliance with
/ the License. You may obtain a copy of the License at
/ http://www.mozilla.org/MPL/
/ 
/ Software distributed under the License is distributed on an "AS IS" basis,
/ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
/ for the specific language governing rights and limitations under the
/ License.
/
/ The Original Code is the FreeXL library
/
/ The Initial Developer of the Original Code is Alessandro Furieri
/ 
/ Portions created by the Initial Developer are Copyright (C) 2011
/ the Initial Developer. All Rights Reserved.
/ 
/ Contributor(s):
/ 
/ Alternatively, the contents of this file may be used under the terms of
/ either the GNU General Public License Version 2 or later (the "GPL"), or
/ the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
/ in which case the provisions of the GPL or the LGPL are applicable instead
/ of those above. If you wish to allow use of your version of this file only
/ under the terms of either the GPL or the LGPL, and not to allow others to
/ use your version of this file under the terms of the MPL, indicate your
/ decision by deleting the provisions above and replace them with the notice
/ and other provisions required by the GPL or the LGPL. If you do not delete
/ the provisions above, a recipient may use your version of this file under
/ the terms of any one of the MPL, the GPL or the LGPL.
/ 
*/

#ifdef DLL_EXPORT
#define FREEXL_DECLARE __declspec(dllexport)
#else
#define FREEXL_DECLARE extern
#endif

#ifndef _FREEXL_H
#define _FREEXL_H

#ifdef __cplusplus
extern "C"
{
#endif

/* constants */
#define FREEXL_UNKNOWN			0

/* CFBF constants */
#define FREEXL_CFBF_VER_3		3
#define FREEXL_CFBF_VER_4		4
#define FREEXL_CFBF_SECTOR_512		512
#define FREEXL_CFBF_SECTOR_4096		4096

/* BIFF versions */
#define FREEXL_BIFF_VER_2		2
#define FREEXL_BIFF_VER_3		3
#define FREEXL_BIFF_VER_4		4
#define FREEXL_BIFF_VER_5		5
#define FREEXL_BIFF_VER_8		8

/* BIFF MaxRecordSize */
#define FREEXL_BIFF_MAX_RECSZ_2080	2080
#define FREEXL_BIFF_MAX_RECSZ_8224	8224

/* BIFF DateMode */
#define FREEXL_BIFF_DATEMODE_1900	1900
#define FREEXL_BIFF_DATEMODE_1904	1904

/* BIFF Obsfuscated */
#define FREEXL_BIFF_OBFUSCATED		3003
#define FREEXL_BIFF_PLAIN		3004

/* BIFF CodePage */
#define FREEXL_BIFF_ASCII		0x016F
#define FREEXL_BIFF_CP437		0x01B5
#define FREEXL_BIFF_CP720		0x02D0
#define FREEXL_BIFF_CP737		0x02E1
#define FREEXL_BIFF_CP775		0x0307
#define FREEXL_BIFF_CP850		0x0352
#define FREEXL_BIFF_CP852		0x0354
#define FREEXL_BIFF_CP855		0x0357
#define FREEXL_BIFF_CP857		0x0359
#define FREEXL_BIFF_CP858		0x035A
#define FREEXL_BIFF_CP860		0x035C
#define FREEXL_BIFF_CP861		0x035D
#define FREEXL_BIFF_CP862		0x035E
#define FREEXL_BIFF_CP863		0x035F
#define FREEXL_BIFF_CP864		0x0360
#define FREEXL_BIFF_CP865		0x0361
#define FREEXL_BIFF_CP866		0x0362
#define FREEXL_BIFF_CP869		0x0365
#define FREEXL_BIFF_CP874		0x036A
#define FREEXL_BIFF_CP932		0x03A4
#define FREEXL_BIFF_CP936		0x03A8
#define FREEXL_BIFF_CP949		0x03B5
#define FREEXL_BIFF_CP950		0x03B6
#define FREEXL_BIFF_UTF16LE		0x04B0
#define FREEXL_BIFF_CP1250		0x04E2
#define FREEXL_BIFF_CP1251		0x04E3
#define FREEXL_BIFF_CP1252		0x04E4
#define FREEXL_BIFF_CP1253		0x04E5
#define FREEXL_BIFF_CP1254		0x04E6
#define FREEXL_BIFF_CP1255		0x04E7
#define FREEXL_BIFF_CP1256		0x04E8
#define FREEXL_BIFF_CP1257		0x04E9
#define FREEXL_BIFF_CP1258		0x04EA
#define FREEXL_BIFF_CP1361		0x0551
#define FREEXL_BIFF_MACROMAN		0x2710

/* CELL VALUE Types */
#define FREEXL_CELL_NULL		101
#define FREEXL_CELL_INT			102
#define FREEXL_CELL_DOUBLE		103
#define FREEXL_CELL_TEXT		104
#define FREEXL_CELL_SST_TEXT		105
#define FREEXL_CELL_DATE		106
#define FREEXL_CELL_DATETIME		107
#define FREEXL_CELL_TIME		108

/* INFO params */
#define FREEXL_CFBF_VERSION		32001
#define FREEXL_CFBF_SECTOR_SIZE		32002
#define FREEXL_CFBF_FAT_COUNT		32003
#define FREEXL_BIFF_VERSION		32005
#define FREEXL_BIFF_MAX_RECSIZE		32006
#define FREEXL_BIFF_DATEMODE		32007
#define FREEXL_BIFF_PASSWORD		32008
#define FREEXL_BIFF_CODEPAGE		32009
#define FREEXL_BIFF_SHEET_COUNT		32010
#define FREEXL_BIFF_STRING_COUNT	32011
#define FREEXL_BIFF_FORMAT_COUNT	32012
#define FREEXL_BIFF_XF_COUNT		32013

/* Error codes */
#define FREEXL_OK			0
#define FREEXL_FILE_NOT_FOUND		-1
#define FREEXL_NULL_HANDLE		-2
#define FREEXL_INVALID_HANDLE		-3
#define FREEXL_INSUFFICIENT_MEMORY	-4
#define FREEXL_NULL_ARGUMENT		-5
#define FREEXL_INVALID_INFO_ARG		-6
#define FREEXL_INVALID_CFBF_HEADER	-7
#define FREEXL_CFBF_READ_ERROR		-8
#define FREEXL_CFBF_SEEK_ERROR		-9
#define FREEXL_CFBF_INVALID_SIGNATURE	-10
#define FREEXL_CFBF_INVALID_SECTOR_SIZE	-11
#define FREEXL_CFBF_EMPTY_FAT_CHAIN	-12
#define FREEXL_CFBF_ILLEGAL_FAT_ENTRY	-13
#define FREEXL_BIFF_INVALID_BOF		-14
#define FREEXL_BIFF_INVALID_SST		-15
#define FREEXL_BIFF_ILLEGAL_SST_INDEX	-16
#define FREEXL_BIFF_WORKBOOK_NOT_FOUND	-17
#define FREEXL_BIFF_ILLEGAL_SHEET_INDEX	-18
#define FREEXL_BIFF_UNSELECTED_SHEET	-19
#define FREEXL_INVALID_CHARACTER	-20
#define FREEXL_UNSUPPORTED_CHARSET	-21
#define FREEXL_ILLEGAL_CELL_ROW_COL	-22
#define FREEXL_ILLEGAL_RK_VALUE		-23
#define FREEXL_ILLEGAL_MULRK_VALUE	-23

    FREEXL_DECLARE int freexl_open (const char *path, const void **xls_handle);
    FREEXL_DECLARE int freexl_open_info (const char *path,
					 const void **xls_handle);
    FREEXL_DECLARE int freexl_close (const void *xls_handle);
    FREEXL_DECLARE int freexl_get_info (const void *xls_handle,
					unsigned short what,
					unsigned int *info);
    FREEXL_DECLARE int freexl_get_worksheet_name (const void *xls_handle,
						  unsigned short sheet_index,
						  const char **string);
    FREEXL_DECLARE int freexl_select_active_worksheet (const void *xls_handle,
						       unsigned short
						       sheet_index);
    FREEXL_DECLARE int freexl_get_active_worksheet (const void *xls_handle,
						    unsigned short
						    *sheet_index);
    FREEXL_DECLARE int freexl_worksheet_dimensions (const void *xls_handle,
						    unsigned int *rows,
						    unsigned short *columns);
    FREEXL_DECLARE int freexl_get_SST_string (const void *xls_handle,
					      unsigned short string_index,
					      const char **string);
    FREEXL_DECLARE int freexl_get_FAT_entry (const void *xls_handle,
					     unsigned int sector_index,
					     unsigned int *next_sector_index);
    FREEXL_DECLARE int freexl_get_cell_value (const void *xls_handle,
					      unsigned int row,
					      unsigned short column,
					      unsigned char *type,
					      int *int_value,
					      double *double_value,
					      const char **text_value);

#ifdef __cplusplus
}
#endif

#endif				/* _FREEXL_H */
