/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1

Item {
    anchors {
        fill: parent
    }
    width: parent.width


    Text {
        id: noAccountsMsg
        anchors {
            margins: units.gu(2)
        }
        width: parent.width * 0.9
        text: i18n.tr("No online accounts configured, you can add one in System Settings")
        font.family: "Ubuntu"
        font.bold: true
        font.pointSize: 18
        wrapMode: Text.WordWrap
        color: "gray"
    }

    /*
    Button {
        id: addButton
        anchors {
            top: parent.top
            left: noAccountsMsg.right
            margins: units.gu(2)
        }
        text: i18n.tr("Add Accounts")
        onClicked: {
            console.log ("Add Accounts activated");
            Qt.openUrlExternally("system:///credentials");

        }
    }
    */

}

