/*
 * Copyright 2013 Canonical Ltd.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * telephony-app is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1
import Ubuntu.OnlineAccounts 0.1
import Friends 0.1

MainView {
    id: main
    applicationName: "friends-app"
    // objectName for functional testing purposes (autopilot-qt5)
    objectName: "main"

    width: units.gu(60)
    height: units.gu(90)
    property bool isPortrait: (height > width)

    AccountServiceModel {
        id: accounts
        serviceType: "microblogging"
    }

    FriendsDispatcher {
        id: friends
    }

    PageStack {
        id: pageStack
        anchors.fill: parent
        Component.onCompleted: {
            console.log ("accounts.count: "+accounts.count);
            pageStack.push(timelinePage);
            if (accounts.count < 1)
                pageStack.push(noAccountsPage);
        }

        Page {
            id: noAccountsPage
            title: i18n.tr("Setup Accounts")
            Setup {
                id: noAccounts
                anchors {
                    fill: parent
                }
            }
            visible: false
            tools: ToolbarActions {
                lock: true
                active: true
            }
        }

        Page {
            id: postPage
            title: i18n.tr("Share with your friends")
            Post {
                id: post
                anchors {
                    fill: parent
                }
            }
            visible: false
            tools: ToolbarActions {
                lock: true
                active: true
            }
        }

        Page {
            id: timelinePage
            title: i18n.tr("Timeline")
            visible: false
            TimeLine {
                id: timeline
                anchors {
                    fill: parent
                }
            }
            tools: ToolbarActions {
                lock: true
                active: true
                Action {
                    text: i18n.tr("Top")
                    iconSource: ("images/go-top.png")
                    onTriggered: {
                        timeline.jumpToTop();
                    }
                }
                Action {
                    text: i18n.tr("Refresh")
                    iconSource: ("images/reload.png")
                    onTriggered: {
                        friends.refresh();
                    }
                }
                Action {
                    text: i18n.tr("Post")
                    iconSource: ("images/new.png")
                    onTriggered: {
                        pageStack.push(postPage);
                    }
                }
            }
        }
    }
}
