import codecs
from os import chmod

class WriteCode:
    def __init__(self, charset="ASCII"):
        self.charset = charset
        self.indent = u' ' * 4
        self.base_level = 0

    def useStream(self, stream):
        self.output = stream

    def createFile(self, filename, mode=None):
        self.output = codecs.open(filename, 'w', self.charset)
        if mode:
            chmod(filename, mode)

    def close(self):
        if not self.output:
            return
        self.output.close()
        self.output = None

    def _writeLine(self, line):
        print >>self.output, line

    def emptyLine(self):
        self._writeLine('')

    def addLevel(self, delta):
        level = self.base_level
        self.base_level += delta
        return level

    def restoreLevel(self, level):
        self.base_level = level

    def indentLine(self, level, text):
        if not isinstance(text, unicode):
            text = unicode(text, 'ASCII')
        return self.indent * (self.base_level + level) + text

    def write(self, level, text):
        line = self.indentLine(level, text)
        self._writeLine(line)

