<xsl:stylesheet version="1.0"
       xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>


<xsl:output method="xml" version="1.0" indent="yes" />

<xsl:template match="//Option" mode="print_ns"></xsl:template>

<xsl:template match="*" mode="print_ns">
<xsl:param name="offset"/>
<xsl:value-of select="$offset"/><xsl:value-of select="name()"/>   name: <xsl:value-of select="@name"/>   namespace: <xsl:value-of select="namespace-uri()"/>
<xsl:text>
</xsl:text>

  <xsl:apply-templates mode="print_ns">
    <xsl:with-param name="offset" select="concat('  ', $offset)"/>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="/">
  <xsl:variable name="initial_offset">  </xsl:variable>
  <xsl:apply-templates mode="print_ns">
    <xsl:with-param name="offset" select="$initial_offset"/>
  </xsl:apply-templates>
</xsl:template>

</xsl:stylesheet>

