/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: BackgroundOpWidget.hh,v 1.19 2002/08/29 00:34:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _BACKGROUND_Op_DISPLAY_HH_
#define _BACKGROUND_Op_DISPLAY_HH_

#include "config.h"

#include "fwbuilder/BackgroundOp.hh"
#include "fwbuilder/Logger.hh"
#include <fstream>

#include <gtk--.h>
#include <gtk--/packer.h>

class BackgroundOpWidget : public Gtk::Packer
{
    void on_hide();
    void init();

    protected:

    libfwbuilder::BackgroundOp *bop;
    libfwbuilder::Logger       *logger;

    int           completed_op_arg;

    Gtk::CList    *text;

    gint monitor_operation();

    public:

    /**
     * Widget managing background operation represented by object
     * of class BackgroundOp .
     *
     * step 1: 
     * 
     *  create BackgroundOpWidget and connect BackgroundOp object to
     *  it. Connect handler to signal completed, this callack is
     *  called *when background operation finishes. Finally call method
     *  execute to initiate background operation.
     *
     * step 2: 
     * 
     *  when background operation is done:
     *
     *    2.1 if widget should be reused, then disconnect BackgroundOp and
     *        delete it, then use method connect to connect another instance
     *        of BackgroundOp and call execute to launch operation again
     *
     *    2.2 if widget should not be reused, then disconnect BackgroundOp 
     *        and delete it, then delete widget object
     */

    BackgroundOpWidget();
    BackgroundOpWidget(libfwbuilder::BackgroundOp *);
    virtual ~BackgroundOpWidget();

    void    connect(libfwbuilder::BackgroundOp *);
    void    disconnect();

    virtual void execute()  throw(libfwbuilder::FWException);
    void stop();

    virtual BackgroundOpWidget& operator<< (const char   *str);
    virtual BackgroundOpWidget& operator<< (const string &str);
    virtual BackgroundOpWidget& operator<< (int    i);

    /**
     *  clears text buffer
     */
    void    clear();

    SigC::Signal1<int,int>completed;

    string  getLogText();
};

#endif


