/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: BuiltinDialog.hh,v 1.15 2002/10/19 09:46:19 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef __BUILTINDIALOG_HH
#define __BUILTINDIALOG_HH

#include <gtk--.h>
#include <gtk--/packer.h>

#include "fwbuilder/FWObject.hh"

class DialogPlugin;
class main_window;

class BuiltinDialog : public Gtk::Packer
{   

protected:

  bool            data_changed;  // true if data needs to be saved 


private:

    main_window      *mw;

    Gtk::VBox        *vbox;    
    Gtk::HBox        *action_area;
    Gtk::HSeparator  *separator;

    GtkButton *gtk_button1;
    GtkButton *gtk_button2;

    Gtk::Button      *save_btn;
    Gtk::Button      *undo_btn;

    Gtk::ScrolledWindow *scrolled_win;

    Gtk::Widget      *dbp;
    DialogPlugin     *dialog_body;

    string            library;

    void  dialog_set_changed_callback_helper(Gtk::Widget *wp);

    void  on_save_clicked();
    void  on_undo_clicked();

protected:

    libfwbuilder::FWObject       *original;

    /*
     *  these are substitutions for standard functions from Gtk::Widget and
     *  Gtk::Dialog
     *  Since we derive this class from Gtk::Packer, it misses these functions
     */
    Gtk::VBox* get_vbox()        { return vbox;        }
    Gtk::HBox* get_action_area() { return action_area; }

    void set_policy(gint allow_shrink, gint allow_grow, gint auto_shrink);
    void set_position(GtkWindowPosition position);
    void set_title(const Gtk::nstring& title);
  
public:
    BuiltinDialog(main_window *mw,const string &id);
    ~BuiltinDialog();

    void InitializeBuiltinDialog(libfwbuilder::FWObject *obj);
    void ConnectSignals();

    void data_changed_flag(bool f);

    void LoadData();
    void SaveData();
    void UndoChanges();

    void OnDataChanged();
    void OnHide();
    gint on_focus_out_event(GdkEventFocus *ev);
    bool IsDataChanged() { return(data_changed); }

    DialogPlugin*           getDialog() { return dialog_body; }
    libfwbuilder::FWObject* getObject() { return original;    }
};
        
#endif
