/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: CertDruidP20Dialog.cc,v 1.3 2002/08/29 00:34:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "CertDruidP20Dialog.hh"

CertDruidP20Dialog::CertDruidP20Dialog()
{
    label483->set_line_wrap(true);
    label484->set_line_wrap(true);
    label485->set_line_wrap(true);

}

string CertDruidP20Dialog::getPassphrase1()
{
    return cert_passphrase1->get_text();
}

string CertDruidP20Dialog::getPassphrase2()
{
    return cert_passphrase2->get_text();
}

/*
 * this one is inconvenient. Glade-- sets values to OptionsMenu widget
 * like this:
 *
      Gtk::Menu *_m(manage(new Gtk::Menu()));
      Gtk::MenuItem *_mi;
      _mi = manage(new Gtk::MenuItem("1024"));
      _m->append(*_mi);
      _mi->show();
      _mi->set_user_data((gpointer)0);
      _mi = manage(new Gtk::MenuItem("2048"));
      _m->append(*_mi);
      _mi->show();
      _mi->set_user_data((gpointer)1);

 *  and so on. See in CertDialogP20Dialog_glade.cc
 */

int    CertDruidP20Dialog::getKeyLength()
{
    int n=int( cert_key_length->get_menu()->get_active()->get_user_data() );
    switch (n) {
    case 0:	return 1024;
    case 1:	return 2048;
    case 2:	return 4096;
    case 3:	return 8192;
    }
    return 0;
}

