/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: CertDruidP30Dialog.cc,v 1.13 2003/06/11 04:59:06 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#if 0
#define _XOPEN_SOURCE /* glibc2 needs this for strptime   --vk */
#endif

#include "config.h"
#include "CertDruidP30Dialog.hh"
#include "MessageDialog.hh"

#include <time.h>

using namespace libfwbuilder;

CertDruidP30Dialog::CertDruidP30Dialog()
{
    label486->set_line_wrap(true);
    label487->set_line_wrap(true);
    label560->set_line_wrap(true);

    label495->set_justify(GTK_JUSTIFY_LEFT);
    label502->set_justify(GTK_JUSTIFY_LEFT);

    time_t  t=time(NULL);
    struct tm *tm = localtime( &t );

    tm->tm_sec=0;

    char buf[64];
/*
 *  accroding to man page for strftime, ISO 8601 standard format for
 *  date is %Y-%m-%d
 */
    strftime(buf, 32, "%Y-%m-%d", tm);    date_valid_from->set_text(buf);
    strftime(buf, 32, "%H:%M:%S", tm);    time_valid_from->set_text(buf);

    tm->tm_year+=1;

    strftime(buf, 32, "%Y-%m-%d", tm);    date_valid_until->set_text(buf);
    strftime(buf, 32, "%H:%M:%S", tm);    time_valid_until->set_text(buf);
}

time_t CertDruidP30Dialog::convertToTime(const string &_date,
					 const string& _time)
{
    time_t  t=time(NULL);
    struct tm *tm = localtime( &t );

    string str = _date+" "+_time;

    if (sscanf(str.c_str(),"%4d-%2d-%2d %2d:%2d:%2d",
	       &tm->tm_year,&tm->tm_mon,&tm->tm_mday,
	       &tm->tm_hour,&tm->tm_min,&tm->tm_sec) != 6)   {
	MessageDialog::Error(
"Error in the date or time format. Date in certificate \n\
validity fields should be specified according to the format \n\
'YYYY-MM-DD' and time according to the format 'HH:MM:SS'", this);
	return long(-1);
    }

    tm->tm_mon -= 1;
    tm->tm_year-=1900;  // we get year with all 4 digits
/*
#ifdef __MINGW32__
   // align to tm format.
   tm->tm_mon -= 1;
   tm->tm_year = tm->tm_year + 100;
#endif    
*/
    return mktime(tm);
}

time_t CertDruidP30Dialog::getNotValidBefore()
{
    string d1=date_valid_from->get_text();
    string t1=time_valid_from->get_text();
    return convertToTime(d1,t1);
}

time_t CertDruidP30Dialog::getNotValidAfter()
{
    string d1=date_valid_until->get_text();
    string t1=time_valid_until->get_text();
    return convertToTime(d1,t1);
}

string CertDruidP30Dialog::getDescription()
{
    return description->get_text();
}

void CertDruidP30Dialog::addEntry(vector<X509_entry> &v, int nid, const string &str)
{
    if(str.length())
        v.push_back(X509_entry(nid, str));
}

void CertDruidP30Dialog::getEntries(vector<X509_entry>  &v)
{
    addEntry(v, NID_description           , description->get_text()            );
}
