/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: CertDruidP40Dialog.cc,v 1.4 2002/08/29 00:34:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


 
#include "config.h"
#include "CertDruidP40Dialog.hh"

#include "MessageDialog.hh"

#include <time.h>

using namespace libfwbuilder;

CertDruidP40Dialog::CertDruidP40Dialog()
{
    label491->set_line_wrap(true);
    label491->set_justify(GTK_JUSTIFY_LEFT);

    label492->set_line_wrap(true);
    label492->set_justify(GTK_JUSTIFY_LEFT);

    label493->set_line_wrap(true);
    label493->set_justify(GTK_JUSTIFY_LEFT);
}

void CertDruidP40Dialog::addEntry(vector<X509_entry> &v, int nid, const string &str)
{
    if(str.length())
        v.push_back(X509_entry(nid, str));
}

void CertDruidP40Dialog::getEntries(vector<X509_entry>  &v)
{
    addEntry(v, NID_countryName           , countryName->get_text()            );
    addEntry(v, NID_stateOrProvinceName   , stateOrProvinceName->get_text()    );
    addEntry(v, NID_localityName          , localityName->get_text()           );
    addEntry(v, NID_organizationName      , organizationName->get_text()       );
    addEntry(v, NID_organizationalUnitName, organizationalUnitName->get_text() );
    addEntry(v, NID_commonName            , commonName->get_text()             );
    addEntry(v, NID_pkcs9_emailAddress    , email->get_text()                  );
}
