/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: CertificateDruid.hh,v 1.4 2002/08/29 00:34:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _CERTIFICATE_DRUID_HH
#define _CERTIFICATE_DRUID_HH

#include <Druid.hh>

#include <fwbuilder/crypto.hh>

class CertDruidP20Dialog;
class CertDruidP30Dialog;
class CertDruidP40Dialog;
		       
class CertificateDruid : public Druid {

    bool  running;

    CertDruidP20Dialog  *p20;
    CertDruidP30Dialog  *p30;
    CertDruidP40Dialog  *p40;

    gint on_delete_event(GdkEventAny* ev);

    public:

    CertificateDruid(const string &t, const string& l);

    virtual void     on_prepare();
    virtual gboolean on_next();
    virtual gboolean on_back();
    virtual gboolean on_cancel();
    virtual void     on_finish();

    void run();

    private:

    libfwbuilder::Key         *key  ;
    libfwbuilder::Certificate *cert ;
    std::string               password ;

};

#endif
