/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP30Dialog.hh,v 1.12 2002/08/29 00:34:48 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _DISCOVERYDRUIDP30DIALOG_HH
#  include "DiscoveryDruidP30Dialog_glade.hh"
#  define _DISCOVERYDRUIDP30DIALOG_HH
#include "glademm_support.hh"

#include <vector>
#include <map>

#include "fwbuilder/IPAddress.hh"
#include "fwbuilder/FWException.hh"

class DiscoveryDruidP30Dialog : public DiscoveryDruidP30Dialog_glade
{   
        
    friend class DiscoveryDruidP30Dialog_glade;

    vector<Gtk::RadioButton*>  rbuttons;
    multimap<string,libfwbuilder::IPAddress> ns_records;

    void on_name_server_changed();
    void on_name_server_activate();
    gint on_name_server_focus_in_event(GdkEventFocus *ev);
    
    void clearRButtons();

    public:

    DiscoveryDruidP30Dialog();
    ~DiscoveryDruidP30Dialog();

    libfwbuilder::IPAddress  getNS() throw (libfwbuilder::FWException);

    void runDNSQuery(const string& domain_name)  throw (libfwbuilder::FWException);
};
#endif
