/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP50Dialog.cc,v 1.14 2003/09/22 05:12:40 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "DiscoveryDruidP50Dialog.hh"

#include "fwbuilder/dns.hh"
#include "MessageDialog.hh"
#include "helpers.hh"

using namespace libfwbuilder;


DiscoveryDruidP50Dialog::DiscoveryDruidP50Dialog()
{
    p50_txt_1->set_line_wrap(true);
    p50_txt_1->set_alignment(0.0, 0.5);

    p50_txt_2->set_line_wrap(true);
    p50_txt_2->set_alignment(0.0, 0.5);

    scan_net_addr=manage(new IPAddressWidget());
    scan_net_nm  =manage(new IPAddressWidget());

    addr_packer->add( *scan_net_addr, GTK_SIDE_LEFT );
    nm_packer->add( *scan_net_nm, GTK_SIDE_LEFT );

//    scan_net_addr->setAssociatedNetmaskWidget( scan_net_nm );
}

bool DiscoveryDruidP50Dialog::checkData()
{
    if (seed_host->get_text().empty()) {
        MessageDialog::Error( _("Need name or address for the seed host"), this );
	return false;
    }
    try {

	vector<IPAddress> v=DNS::getHostByName( seed_host->get_text() );
	seed_host_addr = v.front();
	return true;

    } catch(const FWException &ex) 
    {
        MessageDialog::Error( ex.toString(), this );
	return false;
    }

}

void DiscoveryDruidP50Dialog::prepare()
{
    seed_host->grab_focus();
}

