/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP65Dialog.cc,v 1.34 2003/01/29 07:49:16 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "fwbuilder/libfwbuilder-config.h"
#include "DiscoveryDruidP65Dialog.hh"

#include "fwbuilder/snmp.hh"
#include "MessageDialog.hh"
#include "Preferences.hh"

#include "FileSel.hh"

#include <fstream>
#include <cstdlib>

#include <Druid.hh>

using namespace libfwbuilder;


#ifdef HAVE_LIBSNMP


DiscoveryDruidP65Dialog::DiscoveryDruidP65Dialog()
{
    p65_txt_1->set_line_wrap(true);
    p65_txt_1->set_alignment(0.0, 0.5);

    data_ready=false;
    q=NULL;
    bow=NULL;
}

DiscoveryDruidP65Dialog::~DiscoveryDruidP65Dialog()
{
    if (q!=NULL && q->isRunning()) {
	stop_operation();
        bow->disconnect();
        delete q;
    }
}

void DiscoveryDruidP65Dialog::execute(IPAddress seed_addr,
				      const string& snmp_community,
                                      bool recursive,
				      bool include_virtual,
				      bool do_dns,
				      bool follow_p2p,
				      int snmp_retries,int snmp_timeout,
				      int dns_retries,int dns_timeout,
				      int dns_threads,
				      vector<IPNetwork> *incl)
{
    data_ready=false;

    /*
     *  disable "Next" button
     */
    Gtk::Widget *dr = glademm_get_Widget("DiscoveryDruid");
    ((Druid*)dr)->set_buttons_sensitive(true,false,true);
    
    q=new SNMPCrawler();
    q->init(seed_addr, snmp_community,
            recursive,
	    ! include_virtual,
	    do_dns,
            follow_p2p,
	    dns_threads,
            snmp_retries,
            1000000L*snmp_timeout,
	    dns_retries,
	    dns_timeout,
	    incl
    );

/*
 * step 1: create BackgroundOpWidget (or reuse old one) and connect
 *         crawler to it 
 * step 2: when crawler is done, disconnect widget from crawler and
 *         delete crawler object. This step happens in on_complete
 */
    if (bow==NULL) {
        bow=manage(new BackgroundOpWidget() );
        op_progress_vbox->pack_start(*bow,true,true);
        op_progress_vbox->reorder_child(*bow,0);
    }

    bow->connect(q);

    bow->clear();
    bow->show();

    try
    {
        bow->execute();   // not modal, this just starts operation
        completed_conn=bow->completed.connect(SigC::slot(this,
				  &DiscoveryDruidP65Dialog::on_completed));
        interrupt->set_sensitive(true);

	status_str->set_text(_("Collecting data ..."));


    } catch(const FWException &ex)
    {
        bow->disconnect();
        delete q;
	q=NULL;
    }


}

int DiscoveryDruidP65Dialog::on_completed(int arg)
{

    interrupt->set_sensitive(false);

/*
 *  now we convert data gathered and returned by crawler to more convenient
 *  format
 */
    crawlerNets.clear();
    crawlerHosts.clear();


    set<IPNetwork>::iterator m;
    set<IPNetwork> s = q->getNetworks();
    for (m=s.begin(); m!=s.end(); ++m)
	crawlerNets.push_back( (*m) );

    
    map<IPAddress, CrawlerFind>  t = q->getAllIPs();
    for(map<IPAddress, CrawlerFind>::iterator j = t.begin(); j!=t.end(); ++j) 
    {

	ObjectDescriptor od( (*j).second );
	od.addr     = (*j).first;

	if (od.sysname.empty() && 
	    od.dns_info.name.empty() && 
	    od.dns_info.aliases.size()==0 ) 
        {
	    od.sysname=string("h-") + od.addr.toString();
	}

	crawlerHosts.push_back(od);
    }

    data_ready=true;
    completed_conn.disconnect();

    bow->disconnect();
    delete q;
    q=NULL;

    status_str->set_line_wrap(true);
    status_str->set_text(
	(arg==0) ? 
	_("Network scan completed, click 'Next' to continue") : 
	_("There has been an error running the network scan. You can continue but data gathered by the scanner may be incomplete") 
    );

// enable "Next" button
    Gtk::Widget *dr= glademm_get_Widget("DiscoveryDruid");
    ((Druid*)dr)->set_buttons_sensitive(true,true,true);

    return 0;
}

void DiscoveryDruidP65Dialog::on_interrupt_clicked()
{
    stop_operation();
    on_completed(1);
//    interrupt->set_sensitive(false);
}

void DiscoveryDruidP65Dialog::stop_operation()
{
    q->stop_operation();
    data_ready=false;
//    completed_conn.disconnect();
}


bool DiscoveryDruidP65Dialog::ready()
{
    return data_ready;
}

void DiscoveryDruidP65Dialog::on_save_to_file_clicked()
{
    if (bow==NULL) return;

    string  log=bow->getLogText();


    FileSel *fs=new FileSel(_("Select file"),
			    Preferences::global_prefs->getWdir(),
			    "*.log");

    string f=fs->run();
    delete fs;
    if (f=="") return;

    std::ofstream out( f.c_str() );
    if(out.fail()) {
	MessageDialog::Error(_("Could not open file for writing"),this);
	return;
    }

    out << log;
}

#else

/*
 *  This Druid page will never be shown if SNMP support is not compiled in
 */
DiscoveryDruidP65Dialog::DiscoveryDruidP65Dialog()  {}
DiscoveryDruidP65Dialog::~DiscoveryDruidP65Dialog() {}

void DiscoveryDruidP65Dialog::execute(IPAddress seed_addr,
				      const string& snmp_community,
                                      bool recursive,
				      bool include_virtual,
				      bool do_dns,
				      bool follow_p2p,
				      int snmp_retries,int snmp_timeout,
				      int dns_retries,int dns_timeout,
				      int dns_threads,
				      vector<IPNetwork> *incl) {}
int  DiscoveryDruidP65Dialog::on_completed(int arg) { return 0; }
void DiscoveryDruidP65Dialog::stop_operation() {}
bool DiscoveryDruidP65Dialog::ready()  {  return false;}
void DiscoveryDruidP65Dialog::on_save_to_file_clicked() {}
void DiscoveryDruidP65Dialog::on_interrupt_clicked() {}

#endif
