/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FWObjectBook.hh,v 1.14 2002/09/26 02:41:53 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _FWOBJECTBOOK_HH
#define _FWOBJECTBOOK_HH

#include <gtk--.h>

#include "fwbuilder/FWObject.hh"
#include "helpers.hh"

class ObjectTree;
class main_window;

class FWObjectBook : public Gtk::EventBox 
{   
    main_window                *main_w;
    Gtk::Notebook              *nb;
    string                      mode;

/* this maps Notebook page number to ObjectTree */
    map<unsigned,class ObjectTree*>  trees;  
/* this maps Notebook page number to library name   */
    map<unsigned,string>             libraries;

    void on_switch_page(Gtk::Notebook_Helpers::Page* p0,guint p1);

    void scanObjectDatabase(libfwbuilder::FWObject *obj);

    int         getPage(libfwbuilder::FWObject *o,const std::string &lib);
    ObjectTree* openPage(libfwbuilder::FWObject *o,const std::string &lib);

public:

    FWObjectBook(main_window *mw);

    void   build();
    void   rebuild();
    
    void   setMode( const string &mode );

    void   addPage(const string& lib_name,const string& tab_name);
    void   showPage(unsigned page_num);

    void   insertObject( const string &id );
    void   insertObject( libfwbuilder::FWObject *o );

    void   removeObject( const string &id );
    void   removeObject( libfwbuilder::FWObject *o );

    void   changeTreeLabel(const string &id);

    string getCurrentSelection();
    string getCurrentLibrary();

/**
 *  This method opens appropriate tree if book is in "Split" mode and
 *  shows object with given ID in the tree. It does not open dialog though.
 */
    void   showObject(const string &id);
    void   showObject(libfwbuilder::FWObject *o);
    void   showObject(libfwbuilder::FWObject *o, const string &lib);
    void   showObject(const string &id, const string &lib);

    void   selectObject(const string &id);

    void   sortSubtree(const string &id,int col=0);

/**
 *  clears selection on the current page
 */
    void   clearSelection();

/**
 *  clears selection on all pages except page 'tree'
 */ 
    void   clearSelectionOnAllPages(ObjectTree *tree);

    string   getNextId();
    string   getPrevId();
    string   getParentId();
};

#endif
