/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FWObjectDatabaseGUI.hh,v 1.17 2003/03/28 08:04:46 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _FWOBJECTDATABASEGUI_HH
#define _FWOBJECTDATABASEGUI_HH

#include "fwbuilder/FWObjectDatabase.hh"
#include "fwbuilder/Host.hh"
#include "fwbuilder/Group.hh"
#include "fwbuilder/XMLTools.hh"

#include "MessageDialog.hh"
#include "InterfaceData.hh"

class libfwbuilder::Group;

class FWObjectDatabaseGUI : public libfwbuilder::FWObjectDatabase
{
    private:

    protected:

    public:

    static const string DB_TEMPLATE_FILE_NAME ;

    FWObjectDatabaseGUI();
    FWObjectDatabaseGUI(const string &filename) throw(libfwbuilder::FWException);

    virtual ~FWObjectDatabaseGUI();

    // --- XML import/export ---

    /**
     *   this is the main "Create" method:
     *   it creates instance of FWObject of given type
     */
    virtual libfwbuilder::FWObject *create(const string &type, bool create_with_root=false);
    
    // --- Load/Save ---
    
    virtual void load           (const string &f, bool check_perm ) throw(libfwbuilder::FWException);
    virtual void saveFile       (const string &filename           ) throw(libfwbuilder::FWException);

    void save           () throw(libfwbuilder::FWException);
    void saveAs         () throw(libfwbuilder::FWException);
    bool saveIfModified () throw(libfwbuilder::FWException);
    
/*
 * the following methods create an object and put it in the tree. If
 * tagret is not NULL, then new object will be made a child of target,
 * otherwise it will be placed in a standard subtree.
 *
 * Unlike FWObjectDatabase, class FWObjectDatabaseGUI has knowledge of
 * the tree structure used in Firewall Builder; these methods enforce
 * this knowlege.
 */
    static libfwbuilder::FWObject*  newFirewall(const string &target_id="");
    static libfwbuilder::FWObject*  newHost(const string &target_id="");
    static libfwbuilder::FWObject*  newIPv4(const string &target_id="");
    static libfwbuilder::FWObject*  newPhysAddress(const string &target_id="");
    static libfwbuilder::FWObject*  newInterface(const string &target_id="");
    static libfwbuilder::FWObject*  newNetwork(const string &target_id="");
    static libfwbuilder::FWObject*  newAddressRange(const string &target_id="");
    static libfwbuilder::FWObject*  newObjectGroup(const string &target_id="");
    static libfwbuilder::FWObject*  newIPService(const string &target_id="");
    static libfwbuilder::FWObject*  newICMPService(const string &target_id="");
    static libfwbuilder::FWObject*  newTCPService(const string &target_id="");
    static libfwbuilder::FWObject*  newUDPService(const string &target_id="");
    static libfwbuilder::FWObject*  newCustomService(const string &target_id="");
    static libfwbuilder::FWObject*  newServiceGroup(const string &target_id="");
    static libfwbuilder::FWObject*  newInterval(const string &target_id="");

/**
 * This method creates interfaces for the object 'obj' using SNMP
 * query. Widget 'wnd' is there so that error dialogs can be transient
 * for some top level window. Sometimes run this method from within
 * the main window, and sometimes from the druid.
 */
    static std::list<InterfaceData> newInterfaceDataViaSNMP( libfwbuilder::Host *obj , Gtk::Widget *wnd=NULL);

/**
 * This method creates interfaces for the object 'obj' using SNMP
 * query. Widget 'wnd' is there so that error dialogs can be transient
 * for some top level window. Sometimes run this method from within
 * the main window, and sometimes from the druid.
 */
    static std::list<libfwbuilder::FWObject*> newInterfacesViaSNMP( libfwbuilder::Host *obj , Gtk::Widget *wnd=NULL);

/**
 * This method creates interfaces for the object designated by ID "target_id"
 * using SNMP query
 */
    static std::list<libfwbuilder::FWObject*> newInterfacesViaSNMP( const string &target_id , Gtk::Widget *wnd=NULL );


/**
 * This method checks if object obj can be placed in the tree branch
 * target.  This method uses knowledge about tree structure used in
 * Firewall builder
 *
 */
    static bool validateObjectForPositionInTree(libfwbuilder::FWObject* target,
						libfwbuilder::FWObject* obj);

/**
 * This method places new object obj in the tree branch designated by
 * ID "where_id", but first it checks if this object is appropriate in
 * that branch.
 */    
    static libfwbuilder::FWObject*  newObject(const string& where_id , 
					      libfwbuilder::FWObject *obj,
                                              bool  set_defaults=true);



    static FWObjectDatabaseGUI* getInstance() { return  dynamic_cast<FWObjectDatabaseGUI*>(db); }

/**
 * assigns name for this object following some built-in rules.
 * For example, IPv4 objects get name that is a combination of names of
 * their parent Host and Interface objects
 */
    static void defaultNamingScheme(libfwbuilder::FWObject *obj);

    static const std::string getObjectsId()        { return "stdid01"; }
    static const std::string getHostsId()          { return "stdid02"; }
    static const std::string getNetworksId()       { return "stdid03"; }
    static const std::string getObjectGroupsId()   { return "stdid04"; }
    static const std::string getServicesId()       { return "stdid05"; }
    static const std::string getIPServicesId()     { return "stdid06"; }
    static const std::string getICMPServicesId()   { return "stdid07"; }
    static const std::string getUDPServicesId()    { return "stdid08"; }
    static const std::string getTCPServicesId()    { return "stdid09"; }
    static const std::string getServiceGroupsId()  { return "stdid10"; }
    static const std::string getCustomServicesId() { return "stdid13"; }

    static const std::string getTimeId()           { return "stdid11"; }
    static const std::string getFirewallsId()      { return "stdid12"; }

    static const std::string getAddressRangesId()  { return "stdid15"; }



};

class MessageBoxUpgradePredicate: public libfwbuilder::XMLTools::UpgradePredicate
{
    public:
    virtual bool operator()(const string &msg) const 
    { 
        return MessageDialog::YesNo(msg)==MessageDialog::OK_YES;
    }
};

#endif











