/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: InterfaceDialog.hh,v 1.20 2002/12/25 01:31:10 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/




#ifndef _INTERFACEDIALOG_HH
#  include "InterfaceDialog_glade.hh"
#  define _INTERFACEDIALOG_HH

#include "config.h"

#include "glademm_support.hh"

#include "fwbuilder/Interface.hh"

class IPAddressWidget;

class InterfaceDialog : public InterfaceDialog_glade
{   
    friend class InterfaceDialog_glade;

    void on_regular_toggled();
    void on_dyn_addr_toggled();
    void on_unnum_toggled();
    void on_changed();
    void on_extint_toggled();

    map<string,string>         net_zone_objects;
    vector<class DialogOption> object_parameters;
    bool supports_security_levels;
    bool supports_network_zones;
    bool parent_is_host;

public:

    InterfaceDialog(libfwbuilder::FWObject *obj);
    virtual ~InterfaceDialog();

    virtual void wrk2dlg();
    virtual bool dlg2wrk();

    virtual void updateMainMenu();
};
#endif

