/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: InterfaceListWidget.hh,v 1.10 2003/01/19 08:43:03 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _INTERFACE_LIST_WIDGET_HH_
#define _INTERFACE_LIST_WIDGET_HH_

#include "config.h"

#include <gtk--.h>

#include "InterfaceData.hh"
#include "fwbuilder/Interface.hh"

class InterfaceListWidget : public Gtk::CList {

    bool show_addr, show_name, show_netmask, show_ext, show_dyn, show_mac, show_label;
    bool show_security_level;

/*
 * abbreviations used to mark dynamic and unnumbered interfaces in the widget
 */
    #define DYN_CODE   "dyn"
    #define UNNUM_CODE "unnum"

    public:

    InterfaceListWidget();
    
    void set_show_name(bool onoff);
    void set_show_address(bool onoff);
    void set_show_netmask(bool onoff);
    void set_show_ext(bool onoff);
    void set_show_dyn(bool onoff);
    void set_show_label(bool onoff);
    void set_show_mac(bool onoff);

    void set_show_security_level(bool onoff);

    void addInterface(const InterfaceData        &idata);
    void updateInterface(const InterfaceData     &idata);
    void removeInterface(const std::string       &id);
    void updateInterface(unsigned row, const InterfaceData   &idata);

    void select(unsigned idx);

    InterfaceData getInterface(unsigned row);
    InterfaceData getInterface(const std::string &id);

    std::list<InterfaceData> getInterfaces();
    void    setInterfaces(std::list<InterfaceData> &ifaces );

    bool    haveInterface(const std::string &id);

    int     getSize();
    int     getRowById(const std::string &id);
    string  getIdByRow(unsigned row);
    string  getSelectedInterfaceId();

    void    clear();
};


#endif
