/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: InterfaceTblWidget.hh,v 1.1 2003/01/19 08:43:03 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _INTERFACE_TBL_WIDGET_HH_
#define _INTERFACE_TBL_WIDGET_HH_

#include "config.h"

#include <gtk--.h>

#include "InterfaceData.hh"
#include "fwbuilder/Interface.hh"

class InterfaceTblWidget : public Gtk::Table {

    bool   sec_levels;

    Gtk::Button *title1;
    Gtk::Button *title2;
    Gtk::Button *title3;
    Gtk::Button *title4;

    struct entry {
        InterfaceData idata;
        Gtk::Widget  *name_w;
        Gtk::Widget  *addr_w;
        Gtk::Widget  *label_w;
        Gtk::Widget  *sl_w;
    };

    std::map<int,entry>  interfaces;
    int  selected;

    gint on_button_press_event(GdkEventButton *ev);
    void removeEl(Gtk::Widget *w);

    public:

    InterfaceTblWidget();
    ~InterfaceTblWidget();

    void setTitle();

    void setSecLevels(bool f) { sec_levels=f; }

    void addInterface(const InterfaceData        &idata);

    void select(unsigned idx);
    void activateRow(unsigned r);
    void deactivateRow(unsigned r);

    InterfaceData getInterface(unsigned row);
    std::list<InterfaceData> getInterfaces();
    void    setInterfaces(std::list<InterfaceData> &ifaces );

    int     getSelectedInterfaceNum();

    int     getSize();

    void    clear();
};


#endif
