/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: NewFirewallDruidP30Dialog.cc,v 1.2 2003/03/29 20:31:28 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "NewFirewallDruidP30Dialog.hh"
#include "FWObjectDatabaseGUI.hh"
#include "InterfaceTblWidget.hh"
#include "InterfaceData.hh"

#include "fwbuilder/Resources.hh"

using namespace libfwbuilder;
using namespace std;

NewFirewallDruidP30Dialog::NewFirewallDruidP30Dialog()
{
}

void NewFirewallDruidP30Dialog::prepare()
{
    char str[4096];
    if (supports_security_levels)
    {
        sprintf(str,
                _("In %s, the security level is represented by a number in the range between 0 and 100. Security level 0 corresponds to the least secure interface, while 100 corresponds to the most secure one."),
                platform.c_str());

        sec_level_txt1->set_text(str);

        sec_level_txt2->set_text( _("Select interface in the list below and move it up or down to change its security level.") );

        up->set_sensitive(true);
        down->set_sensitive(true);

    } else 
    {
        sprintf(str,
                _("In %s there are only two security levels: 'external' and 'internal'. Interfaces that connect firewall to the Internet and DMZ subnets are considered 'external'. If firewall has only one interface (protecting a box it is running on), then mark it as 'external' too. Loopback interface is always 'internal'."),
                platform.c_str());

        sec_level_txt1->set_text(str);

        sec_level_txt2->set_text( _("Use checkboxes in the list below to mark external interfaces.") );

        up->set_sensitive(false);
        down->set_sensitive(false);
    }
    iface_list->setSecLevels(supports_security_levels);
    iface_list->setTitle();
}

void NewFirewallDruidP30Dialog::setPlatform(const string &_p)
{
    platform=_p;

    supports_security_levels=Resources::getTargetCapabilityBool(platform,
                                                        "security_levels");
}

void NewFirewallDruidP30Dialog::on_up_clicked()
{  
    int    row=iface_list->getSelectedInterfaceNum();
    if (row>0)
    {
        list<InterfaceData> interfaces=iface_list->getInterfaces();

        int i;
        list<InterfaceData>::iterator j ,k;
        for (i=0,j=interfaces.begin(); i<row && j!=interfaces.end(); i++,j++)
            k=j;

        InterfaceData id1= *j;  // row
        InterfaceData id2= *k;  // row-1

        int sl1=id1.securityLevel;
        int sl2=id2.securityLevel;

        *j = id2;
        *k = id1;

        j->securityLevel=sl1;
        k->securityLevel=sl2;
        
        iface_list->setInterfaces( interfaces );
        iface_list->select(row-1);
    }
}

void NewFirewallDruidP30Dialog::on_down_clicked()
{  
    int    row=iface_list->getSelectedInterfaceNum();
    if (row>=0 && row <= (iface_list->getSize()-2) )
    {
        list<InterfaceData> interfaces=iface_list->getInterfaces();

        int i;
        list<InterfaceData>::iterator j ,k;
        for (i=0,j=interfaces.begin(); i<row+1 && j!=interfaces.end(); i++,j++)
            k=j;

        InterfaceData id1= *j;  // row+1
        InterfaceData id2= *k;  // row

        int sl1=id1.securityLevel;
        int sl2=id2.securityLevel;

        *j = id2;
        *k = id1;

        j->securityLevel=sl1;
        k->securityLevel=sl2;
        
        iface_list->setInterfaces( interfaces );
        iface_list->select(row+1);
    }
}

void NewFirewallDruidP30Dialog::addInterface(const InterfaceData &idata)
{
    iface_list->addInterface(idata);
}

list<InterfaceData>  NewFirewallDruidP30Dialog::getInterfaces()
{
    return iface_list->getInterfaces();
}

void NewFirewallDruidP30Dialog::setInterfaces(list<InterfaceData> &ifaces)
{
    iface_list->setInterfaces(ifaces);
}

