/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ObjectDescriptor.hh,v 1.11 2002/08/29 00:34:50 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef OBJECTDESCRIPTOR_HH
#define OBJECTDESCRIPTOR_HH

#include "config.h"

#include "fwbuilder/Interface.hh"
#include "fwbuilder/IPAddress.hh"

#include "fwbuilder/dns.hh"
#include "fwbuilder/snmp.hh"

#include <vector>
#include <string>

class ObjectDescriptor 
{
    public:

    bool    have_snmpd ;
    string  descr, contact, location, sysname    ;

    map<int, libfwbuilder::Interface> interfaces ;

    string                          MAC_addr ;
    libfwbuilder::HostEnt           dns_info ;
    libfwbuilder::IPAddress         addr     ;


    
    ObjectDescriptor();
    ObjectDescriptor(const ObjectDescriptor& od);

#ifdef HAVE_LIBSNMP
    ObjectDescriptor(const libfwbuilder::CrawlerFind& cf);
#endif

    virtual ~ObjectDescriptor();

    ObjectDescriptor& operator=(const ObjectDescriptor& od);

};

#endif
