/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: OptionMenuWidget.cc,v 1.8 2002/08/29 00:34:50 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "OptionMenuWidget.hh"

#include <gtk--/menu.h>
#include <gtk--/menuitem.h>
#include <gtk--/label.h>

#include <algorithm>
#include <functional>



OptionMenuWidget::OptionMenuWidget() : Gtk::OptionMenu () {}

void OptionMenuWidget::set_menu(vector<string> &itm)
{
    vector<string>::iterator i;

    sorted_items.clear();

    for (i=itm.begin(); i!=itm.end(); ++i) {
//	items[ (*i) ]= (*i);
	sorted_items[ (*i) ]= (*i);
    }
    create_menu();

    current_state=get_value();
}

/*
 * in itm 'first' is the key value and 'second' is the description
 * visible to user in the widget
 */
void OptionMenuWidget::set_menu(map<string,string> &itm)
{
//    items=itm;

/*
 * map "items" is sorted by its first string, which is a key. We want
 * strings in the widget to be sorted by the user-visible description,
 * which is the second string in items. In order to resort it, we pack
 * strings into another map which is designed to hold each pair of
 * strings in the opposite order.
 *
 * TODO: use std:sort here
 */

    sorted_items.clear();

    map<string,string>::iterator i;
    for (i=itm.begin(); i!=itm.end(); ++i) 
	sorted_items[(*i).second]=(*i).first;


    create_menu();
}

void OptionMenuWidget::create_menu(int active_item_n)
{
    Gtk::Menu     *_m(manage(new Gtk::Menu()));
    Gtk::MenuItem *_mi;
    map<string,string>::iterator i;

    remove_menu();

    for (i=sorted_items.begin(); i!=sorted_items.end(); ++i) { 
	_mi = manage(new Gtk::MenuItem( (*i).first ));
//	_m->append(*_mi);
	_mi->set_user_data((gpointer) &((*i).second) );
	_mi->show();
	_m->items().push_back(*_mi);
    }
    _m->set_active( active_item_n );
    _m->selection_done.connect( SigC::slot(this,&OptionMenuWidget::on_menu_selection_changed) );

    Gtk::OptionMenu::set_menu( *_m );

    _m->show_all();

    current_state=get_value();
}

void OptionMenuWidget::set_active_item(int n)
{
    create_menu(n);
}

void OptionMenuWidget::set_active_item_by_label(const string& label)
{
    int                      n;
    map<string,string>::iterator i;

    for (n=0,i=sorted_items.begin(); i!=sorted_items.end(); ++i,++n) {
	if ((*i).first == label) {
	    create_menu(n);
	    break;
	}
    }
}

void OptionMenuWidget::set_active_item_by_value(const string& val)
{
    int                      n;
    map<string,string>::iterator i;

    for (n=0,i=sorted_items.begin(); i!=sorted_items.end(); ++i,++n) {
	if ((*i).second == val) {
	    create_menu(n);
	    break;
	}
    }
}

string OptionMenuWidget::get_value()
{
    string *s;
    Gtk::MenuItem *mi=get_menu()->get_active();
    if (mi) { s=(string*)( mi->get_user_data() ); return *s; }
    return "";
}
    
void OptionMenuWidget::on_menu_selection_changed()
{
    if (current_state!=get_value()) {
	current_state=get_value();

	/* call signal now */
	changed();
    }
}


