/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PolicyListItem.hh,v 1.27 2002/08/29 00:34:50 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _POLICYLISTITEM_HH
#define _POLICYLISTITEM_HH

#include <gtk--.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk--/packer.h>


#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Policy.hh"

class PolicyList;
class PolicyListElement;
class ObjectQuickView;
class SimplePixmap;

class PolicyListItem : public  Gtk::EventBox {

protected:

    gint        x,y,width,height;
    gint        sw, sh;
    libfwbuilder::FWObject   *object;

    gint        icon_size;
    gint        icon_w, icon_h;
    
    std::list<SimplePixmap*>      pixmaps;
    std::list<SimplePixmap*>    n_pixmaps;

    vector<string>       icn_files;


    Gtk::Label          *label;

    Gtk::Packer         *packer;
    Gtk::Table          *tbl;
    Gtk::HBox           *hbox;

    bool        neg;
    bool        overlap;

// quick view text, if set
    string      quick_view_txt;


    gint on_enter_notify_event(GdkEventCrossing* ev);
    gint on_leave_notify_event(GdkEventCrossing* ev);

    virtual gint key_press_event_impl(GdkEventKey* p0);
    virtual void state_changed_impl(GtkStateType p0);

    gint on_button_press_event(GdkEventButton *ev);
    gint on_button_release_event(GdkEventButton *ev);

    void activateObjectQuickView();
    void deactivateObjectQuickView();

public:

    PolicyListItem(const string &pixmap, 
		   const string &neg_pixmap, 
		   const string &label,
		   bool  neg_flag=false);

    virtual ~PolicyListItem();

    string    getLabel();
    libfwbuilder::FWObject* getObject() { return object; }

    void addLabel(const string &txt);
    void addIcon(const string &icn_file,const string &neg_icn_file="");


    void clear();

    void setNeg(bool flag);
    void setOverlap(bool flag);

    void setQuickView(const string &txt);

    PolicyListElement* getParentPolicyListElement();

    virtual void drag_data_received_impl(GdkDragContext* p0,
					 gint p1,
					 gint p2,
					 GtkSelectionData* p3,
					 guint p4,
					 guint32 p5);
};

class PolicyListObjectItem : public PolicyListItem {

    friend class PolicyList;

    void source_drag_begin( GdkDragContext  *context);

    void source_drag_data_get  ( GdkDragContext     *context,
				 GtkSelectionData   *selection_data,
				 guint               info,
				 guint32             time );

public:

    PolicyListObjectItem(libfwbuilder::FWObject *o,
			 bool  neg_flag,
			 bool  change_any_to_orig);


};

class PolicyListRuleNumItem : public PolicyListItem {
    void source_drag_begin( GdkDragContext  *context);
    void source_drag_data_get  ( GdkDragContext     *context,
				 GtkSelectionData   *selection_data,
				 guint               info,
				 guint32             time );
public:
    PolicyListRuleNumItem(const string& label,bool  neg_flag=false);
    void setNum(const string& label);
};


class PolicyListCommentItem : public PolicyListItem {
public:
    PolicyListCommentItem(const string& text);
};


#endif
