/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: SimplePasswordDialog.cc,v 1.7 2002/08/29 00:34:50 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "config.h"
#include "SimplePasswordDialog.hh"
#include "PixmapButton.hh"

SimplePasswordDialog::SimplePasswordDialog( const  string& prompt_txt )
{
    res=false;

    dialog_message->set_text( prompt_txt );


    PixmapButton::addPixmapAndText( *ok_button     , "Ok"     , _("OK")     );
    PixmapButton::addPixmapAndText( *cancel_button , "Cancel" , _("Cancel") );



    password->grab_focus();

    ok_button->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    ok_button->grab_default();

    hide.connect(Gtk::Main::quit.slot());
    show();
}

gint SimplePasswordDialog::key_press_event_impl(GdkEventKey* p0)
{
    if ( p0->keyval == GDK_Escape ) hide();
    if ( p0->keyval == GDK_Return ) {res=true; hide(); }
    SimplePasswordDialog_glade::key_press_event_impl(p0);
    return 0;
}


bool SimplePasswordDialog::run()
{
    Gtk::Main::grab_add(*this);
    Gtk::Main::run();
    Gtk::Main::grab_remove(*this);
    return res;
}

string SimplePasswordDialog::getPwd()
{
    return( password->get_text() );
}

void SimplePasswordDialog::on_ok_button_clicked()
{   
    res=true;
    hide();
}

void SimplePasswordDialog::on_cancel_button_clicked()
{   
    hide();
}

gint SimplePasswordDialog::on_delete_event(GdkEventAny* ev)
{
    hide();
    return true;
}
