/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: SimplePixmap.cc,v 1.3 2003/03/17 04:45:11 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "SimplePixmap.hh"

using namespace std;

map<string, GdkPixbuf*> SimplePixmap::pict_cache;

SimplePixmap::SimplePixmap() : Gtk::Pixmap()
{
    pm=NULL;
    bm=NULL;
}

SimplePixmap::SimplePixmap(const string& filename) : Gtk::Pixmap()
{
    setFromFile(filename);
}

SimplePixmap::~SimplePixmap()
{
    if (pm) free(pm);
    if (bm) free(bm);
}

void SimplePixmap::setFromFile(const string &filename)
{
    pm=NULL;
    bm=NULL;

    if (pict_cache[filename]==NULL)
        pict_cache[filename]=gdk_pixbuf_new_from_file( (char*)(filename.c_str()));

    if (pict_cache[filename]!=NULL)
    {
        gdk_pixbuf_render_pixmap_and_mask(pict_cache[filename], &pm, &bm, 127);

        set(pm,bm);
//            gdk_pixbuf_unref(im);
    }
}
