/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: StandardRulesDruid2.cc,v 1.36 2003/09/21 03:44:39 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
 
#include "fwbuilder/Interface.hh"
#include "fwbuilder/Host.hh"
#include "fwbuilder/Firewall.hh"
#include "fwbuilder/Policy.hh"
#include "fwbuilder/InterfacePolicy.hh"
#include "fwbuilder/NAT.hh"
#include "fwbuilder/Rule.hh"
#include "fwbuilder/RuleElement.hh"
#include "fwbuilder/FWOptions.hh"

#include "StandardRulesDruid.hh"
#include "FWObjectDatabaseGUI.hh"
#include "PolicyList.hh"
#include "BuiltinDialog.hh"


#include "helpers.hh"

#include <gtk--.h>

#include <assert.h>


using namespace libfwbuilder;

/**
 *   This method finds loopback interface
 */
Interface* StandardRulesDruid::findLoopbackInterface()
{
    list<FWObject*> l=fw_object->getByType(Interface::TYPENAME);
    for (list<FWObject*>::iterator m=l.begin(); m!=l.end(); m++) {
	if ( Interface::cast(*m)->isLoopback() ) 
	    return Interface::cast(*m);
    }
    return NULL;
}

/**
 *   This method finds first non-loopback interface
 */
Interface* StandardRulesDruid::findNonLoopbackInterface()
{
    list<FWObject*> l=fw_object->getByType(Interface::TYPENAME);
    for(list<FWObject*>::iterator m=l.begin(); m!=l.end(); m++) {
	if ( ! Interface::cast(*m)->isLoopback() ) 
	    return Interface::cast(*m);
    }
    return NULL;
}


void StandardRulesDruid::generateRulesForHostProtection()
{
    Policy      *pol=((Firewall*)fw_object)->getPolicy();
    InterfacePolicy *ipol, *loipol;
    PolicyRule  *rule;
    RuleElement *rel;
    FWObject    *ifs, *loopback, *smtp, *http, *ssh, *ftp, *telnet, *icmp;

    FWOptions *options=(Firewall::cast(fw_object))->getOptionsObject();

    options->setBool("firewall_is_part_of_any_and_networks", false);

/* 
 *   This is host protection rules, there must be only one
 *   non-loopback interface 
 */
    loopback=ifs=NULL;
    ipol=loipol=NULL;

    ifs     =findNonLoopbackInterface();
    loopback=findLoopbackInterface();

    if (ifs)  
	ipol=(InterfacePolicy*)(ifs->getFirstByType("InterfacePolicy"));
    if (loopback) 
	loipol=(InterfacePolicy*)(loopback->getFirstByType("InterfacePolicy"));

/*************************************************************/


/*************************************************************/

    if (p30->allow_smtp->get_active() ||
	p30->allow_http->get_active() ||
	p30->allow_ssh->get_active()  ||
	p30->allow_ftp->get_active()  ||
	p30->allow_telnet->get_active() ||
	p30->allow_icmp->get_active()  ) {

	smtp=_findObjectByName(FWObjectDatabaseGUI::getServicesId() ,"smtp" );
	http=_findObjectByName(FWObjectDatabaseGUI::getServicesId() ,"http" );
	ssh=_findObjectByName(FWObjectDatabaseGUI::getServicesId() , "ssh" );
	ftp=_findObjectByName(FWObjectDatabaseGUI::getServicesId() , "ftp" );
	telnet=_findObjectByName(FWObjectDatabaseGUI::getServicesId() ,"telnet");
	icmp=_findObjectByName(FWObjectDatabaseGUI::getServicesId() ,"all_icmp_unreachables");

	rule= pol->insertRuleAtTop();
	rule->setAction(PolicyRule::Accept);
	rule->setLogging(false);
	rel=rule->getSrv();

	if (p30->allow_smtp->get_active() && smtp ) {
	    rel->addRef(smtp);
	}

	if (p30->allow_http->get_active() && http ) {
	    rel->addRef(http);
	}

	if (p30->allow_ssh->get_active() && ssh ) {
	    rel->addRef(ssh);
	}

	if (p30->allow_ftp->get_active() && ftp ) {
	    rel->addRef(ftp);
	}

	if (p30->allow_telnet->get_active() && telnet ) {
	    rel->addRef(telnet);
	}

	if (p30->allow_icmp->get_active() && icmp ) {
	    rel->addRef(icmp);
	}

	rel=rule->getDst();
	rel->addRef(fw_object);
    }

    if (p30->short_fragments->get_active()) {

	FWObject *o=_findObjectByName(FWObjectDatabaseGUI::getServicesId()  , 
			    "ip_fragments" );
	if (o) {
	    rule= pol->insertRuleAtTop();
	    rule->setAction(PolicyRule::Deny);
	    rule->setLogging(true);

	    rule->setComment(_("block fragments"));



	    rel=rule->getSrv();
	    rel->addRef(o);

	    rel=rule->getDst();
	    rel->addRef(fw_object);

	    FWOptions* opt=rule->getOptionsObject();
	    if (opt)
		opt->setBool("stateless",true);
	}
    }


/*************************************************************/

    if (p30->allow_all_on_loopback->get_active() && loipol!=NULL) {
	rule= loipol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setDirection(PolicyRule::Both);
	rule->setLogging(false);

	rule->setComment(_("allow everything on loopback"));



	FWOptions* opt=rule->getOptionsObject();
	assert (opt!=NULL);
	opt->setBool("stateless",true);
    }

    if (p30->allow_all_outgoing->get_active() ) {
	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setLogging(false);

	rule->setComment(_("allow all outgoing connections"));


	rel=rule->getSrc();
	rel->addRef(fw_object);
    }


/*************************************************************/

    if (p30->catch_all->get_active() && pol!=NULL) {
	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Deny);
	rule->setLogging(true);

	rule->setComment(_("'catch all' rule"));


	rel=rule->getDst();
	rel->addRef(fw_object);

//	FWOptions* opt=rule->getOptionsObject();
//	if (opt)
//	    opt->setBool("stateless",true);
    }
}


void StandardRulesDruid::generateRulesForNetProtection()
{
    Policy      *pol=((Firewall*)fw_object)->getPolicy();
    NAT         *nat=((Firewall*)fw_object)->getNAT();
    InterfacePolicy *ipol, *loipol;
    PolicyRule  *rule;
    NATRule     *nrule;
    RuleElement *rel;
    FWObject    *ifs, *o, *loopback;
    FWObject    *ssh, *dns, *dhcp, *bcast;

    ssh   =_findObjectByName(FWObjectDatabaseGUI::getServicesId() , "ssh"    );
    dns   =_findObjectByName(FWObjectDatabaseGUI::getServicesId() , "DNS"    );
    dhcp  =_findObjectByName(FWObjectDatabaseGUI::getServicesId() , "DHCP"   );
    bcast =_findObjectByName(FWObjectDatabaseGUI::getAddressRangesId() , "broadcast" );

/* 
 *   Interface chosen on the page ASDruidP11Dialog
 */
    if ( p11->if_list->selection().empty() ) return;

    ifs=(FWObject*)(p11->if_list->selection().front().get_data());
    ipol=(InterfacePolicy*)(ifs->getFirstByType("InterfacePolicy"));

    loipol=NULL;
    loopback=findLoopbackInterface();
    if (loopback) 
	loipol=(InterfacePolicy*)(loopback->getFirstByType("InterfacePolicy"));

/*************************************************************/


    if (p12->anti_spoof_out->get_active()) 
    {
	rule= ipol->insertRuleAtTop();

        rule->setDirection( PolicyRule::Outbound );


	rule->setAction(PolicyRule::Deny);
	rule->setLogging(true);

	rule->setComment(_("Anti-spoofing rule"));



	rel=rule->getSrc();
	_fillRuleElementP20(rel);
	rel->addRef(fw_object);          /* firewall itself */
	rel->setNeg(true);

	FWOptions* opt=rule->getOptionsObject();
	if (opt)
	    opt->setBool("stateless",true);
    }

/*************************************************************/

    if (p12->anti_spoof_in->get_active()) 
    {
	rule= ipol->insertRuleAtTop();

        rule->setDirection( PolicyRule::Inbound );


	rule->setAction(PolicyRule::Deny);
	rule->setLogging(true);

	rule->setComment(_("Anti-spoofing rule"));



	rel=rule->getSrc();
	_fillRuleElementP20(rel);
	rel->addRef(fw_object);          /* firewall itself */

	FWOptions* opt=rule->getOptionsObject();
	if (opt)
	    opt->setBool("stateless",true);
    }

/*************************************************************/

    if (p12->short_fragments->get_active()) 
    {
	o=_findObjectByName(FWObjectDatabaseGUI::getServicesId()  , 
			    "ip_fragments" );

	if (o) {
	    rule= pol->insertRuleAtTop();
	    rule->setAction(PolicyRule::Deny);
	    rule->setLogging(true);
	    rel=rule->getSrv();  rel->addRef(o);
	    FWOptions* opt=rule->getOptionsObject();
	    if (opt)  opt->setBool("stateless",true);
	    rule->setComment(_("block fragments"));
	}
    }

/*************************************************************/

    if (p12->allow_all_on_loopback->get_active() && loipol!=NULL) 
    {
	rule= loipol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setDirection(PolicyRule::Both);
	rule->setLogging(false);

	rule->setComment(_("allow everything on loopback"));

	FWOptions* opt=rule->getOptionsObject();
	assert (opt!=NULL);
	opt->setBool("stateless",true);
    }

    if (p12->ssh_from_anywhere->get_active() && ssh)
    {
	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setLogging(false);
	rel=rule->getDst();   rel->addRef( fw_object );
        rel=rule->getSrv();   rel->addRef(ssh);
	rule->setComment(_("ssh access to firewall"));
    }

    if (p12->ssh_from_lan->get_active() && ssh)
    {
	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setLogging(false);
        rel=rule->getSrc();  _fillRuleElementP20(rel);
	rel=rule->getDst();  rel->addRef( fw_object );
        rel=rule->getSrv();  rel->addRef(ssh);
	rule->setComment(_("ssh access to firewall"));
    }

    if (p12->uses_dns_on_lan->get_active() && dns)
    {
	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setLogging(false);
        rel=rule->getSrc();   rel->addRef( fw_object );
	rel=rule->getDst();   _fillRuleElementP20(rel);
        rel=rule->getSrv();   rel->addRef(dns);
	rule->setComment(_("firewall uses DNS server on LAN"));
    }

    if (p12->uses_dns_on_inet->get_active() && dns)
    {
	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setLogging(false);
        rel=rule->getSrc();   rel->addRef( fw_object );
        rel=rule->getSrv();   rel->addRef(dns);
	rule->setComment(_("firewall uses DNS server on Inet"));
    }

    if (p12->provides_dns_for_lan->get_active() && dns)
    {
	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setLogging(false);
        rel=rule->getSrc();   _fillRuleElementP20(rel);
	rel=rule->getDst();   rel->addRef( fw_object );
        rel=rule->getSrv();   rel->addRef(dns);
	rule->setComment(_("firewall serves as DNS server for LAN"));
    }

    if (p12->provides_dhcp->get_active() && dhcp && bcast)
    {
	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setLogging(false);
        rel=rule->getSrc();   _fillRuleElementP20(rel);
	rel=rule->getDst();   rel->addRef( fw_object ); rel->addRef( bcast );
        rel=rule->getSrv();   rel->addRef(dhcp);
	rule->setComment(_("firewall serves as DHCP server for LAN"));

	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setLogging(false);
	rel=rule->getSrc();   rel->addRef( fw_object );
        rel=rule->getDst();   _fillRuleElementP20(rel);
        rel=rule->getSrv();   rel->addRef(dhcp);
	rule->setComment(_("firewall serves as DHCP server for LAN"));
    }

    if (p12->masquerading->get_active()) 
    {
	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setLogging(false);
	rel=rule->getSrc();	_fillRuleElementP20(rel);

/*  add rule to NAT policy */
	nrule= nat->insertRuleAtTop();
	rel=nrule->getOSrc();	_fillRuleElementP20(rel);
	rel=nrule->getTSrc();	

	list<FWObject*> l2=fw_object->getByType(Interface::TYPENAME);
	for (list<FWObject*>::iterator i=l2.begin(); i!=l2.end(); ++i)
        {
	    Interface *iface=dynamic_cast<Interface*>(*i);
	    assert(iface);

	    if ( iface->isExt() ) 
                rel->addRef(iface);   /* external interface as masq. address */
	}

	rule->setComment(_("'masquerading' rule"));
    }

/*************************************************************/

    if (p12->catch_all->get_active()) 
    {
	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Deny);
	rule->setLogging(true);

//	FWOptions* opt=rule->getOptionsObject();
//        assert(opt!=NULL);
//	opt->setBool("stateless",true);
	rule->setComment(_("'catch all' rule"));
    }
}

void StandardRulesDruid::generateRulesForNetAndDMZProtection()
{
    Policy      *pol=((Firewall*)fw_object)->getPolicy();
    NAT         *nat=((Firewall*)fw_object)->getNAT();
    InterfacePolicy *ipol, *dmzipol, *loipol;
    PolicyRule  *rule;
    NATRule     *nrule;
    RuleElement *rel;
    FWObject    *ifs, *dmzifs, *o, *loopback;

    ipol=dmzipol=loipol=NULL;
    ifs=dmzifs=NULL;

/* 
 *   Interfaces chosen on the page ASDruidP44Dialog
 */
    if ( p44->external_if_list->selection().empty() ) return;
    if ( p44->dmz_if_list->selection().empty() ) return;

    ifs=(FWObject*)(p44->external_if_list->selection().front().get_data());
    if (ifs)
	ipol=(InterfacePolicy*)(ifs->getFirstByType("InterfacePolicy"));

    dmzifs=(FWObject*)(p44->dmz_if_list->selection().front().get_data());
    if (dmzifs)
	dmzipol=(InterfacePolicy*)(ifs->getFirstByType("InterfacePolicy"));

    loopback=findLoopbackInterface();
    if (loopback) 
	loipol=(InterfacePolicy*)(loopback->getFirstByType("InterfacePolicy"));

/*************************************************************/


    if (p47->anti_spoof_out->get_active()) 
    {
	rule= ipol->insertRuleAtTop();

        rule->setDirection( PolicyRule::Outbound );

	rule->setAction(PolicyRule::Deny);
	rule->setLogging(true);

	rule->setComment(_("Anti-spoofing rule"));



	rel=rule->getSrc();
	_fillRuleElementP49net(rel);
	_fillRuleElementP49dmz(rel);
	rel->addRef(fw_object);          /* firewall itself */
	rel->setNeg(true);

	FWOptions* opt=rule->getOptionsObject();
	if (opt)
	    opt->setBool("stateless",true);
    }

/*************************************************************/

    if (p47->anti_spoof_in->get_active()) 
    {
	rule= ipol->insertRuleAtTop();

        rule->setDirection( PolicyRule::Inbound );

	rule->setAction(PolicyRule::Deny);
	rule->setLogging(true);

	rule->setComment(_("Anti-spoofing rule"));



	rel=rule->getSrc();
	_fillRuleElementP49net(rel);
	_fillRuleElementP49dmz(rel);
	rel->addRef(fw_object);          /* firewall itself */

	FWOptions* opt=rule->getOptionsObject();
	if (opt)
	    opt->setBool("stateless",true);
    }

/*************************************************************/

    if (p47->short_fragments->get_active()) 
    {

	o=_findObjectByName(FWObjectDatabaseGUI::getServicesId()  , 
			    "ip_fragments" );
	if (o) 
        {
	    rule= pol->insertRuleAtTop();
	    rule->setAction(PolicyRule::Deny);
	    rule->setLogging(true);

	    rule->setComment(_("block fragments"));



	    rel=rule->getSrv();
	    rel->addRef(o);

	    FWOptions* opt=rule->getOptionsObject();
	    if (opt)
		opt->setBool("stateless",true);
	}
    }

/*************************************************************/

    if (p47->allow_all_on_loopback->get_active() && loipol!=NULL) 
    {
	rule= loipol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setDirection(PolicyRule::Both);
	rule->setLogging(false);

	rule->setComment(_("allow everything on loopback"));



	FWOptions* opt=rule->getOptionsObject();
	assert (opt!=NULL);
	opt->setBool("stateless",true);
    }


/*************************************************************/

    if (p47->masquerading->get_active()) 
    {
/* first add a rule blocking access to internal net and fw from DMZ */

	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Deny);
	rule->setLogging(false);

	rule->setComment(
_("blocking access to internal net\nand firewall from DMZ.\nRules that permit access to servers\non DMZ should be added above.")
);

	rel=rule->getSrc();
	_fillRuleElementP49dmz(rel);

	rel=rule->getDst();
	_fillRuleElementP49net(rel);
	rel->addRef(fw_object);          /* firewall itself */


/* then add masquerading rule */

	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Accept);
	rule->setLogging(false);

	rule->setComment(_("'masquerading' rule"));

	rel=rule->getSrc();
	_fillRuleElementP49net(rel);
	_fillRuleElementP49dmz(rel);

/*  add rule to NAT policy */
	nrule= nat->insertRuleAtTop();

	rel=nrule->getOSrc();
	_fillRuleElementP49net(rel);

	if (p40->dmz_needs_nat->get_active())
	    _fillRuleElementP49dmz(rel);

	rel=nrule->getTSrc();

	list<FWObject*> l2=fw_object->getByType(Interface::TYPENAME);
	for (list<FWObject*>::iterator i=l2.begin(); i!=l2.end(); ++i) 
        {
	    Interface *iface=dynamic_cast<Interface*>(*i);
	    assert(iface);

	    if ( iface->isExt() ) 
                rel->addRef(iface);   /* external interface as masq. address */
	}
    }

/*************************************************************/

    if (p47->catch_all->get_active()) 
    {
	rule= pol->appendRuleAtBottom();
	rule->setAction(PolicyRule::Deny);
	rule->setLogging(true);

	rule->setComment(_("'catch all' rule"));


//	FWOptions* opt=rule->getOptionsObject();
//	if (opt)
//	    opt->setBool("stateless",true);
    }


}

int StandardRulesDruid::_fillRuleElementP20(RuleElement *rel)
{
    return _fillRuleElement(rel,p20->internal_networks);
}

int StandardRulesDruid::_fillRuleElementP49net(RuleElement *rel)
{
    return _fillRuleElement(rel,p49->internal_net);
}

int StandardRulesDruid::_fillRuleElementP49dmz(RuleElement *rel)
{
    return _fillRuleElement(rel,p49->dmz_net);
}

int StandardRulesDruid::_fillRuleElement(RuleElement *rel,Gtk::CList *lst)
{
    FWObject    *o;
    int          n=0;

    Gtk::CList_Helpers::SelectionList      sl=lst->selection();

    for (Gtk::CList_Helpers::SelectionList::iterator si=sl.begin(); 
	 si!=sl.end();  ++si) {
	o=(FWObject*)(si->get_data());
	if (o) {
	    if (rel->getById( o->getId() )!=NULL) continue; // no duplicates
	    rel->addRef(o);
	    n++;
	}
    }
    return n;
}

bool StandardRulesDruid::_checkObjectsList(Gtk::CList *lst)
{    
    Gtk::CList_Helpers::SelectionList      sl=lst->selection();
    return ( ! sl.empty() );
}







