/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TMPGroupObject.hh,v 1.2 2002/08/29 00:34:50 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __TMPGROUP_OBJECT__HH
#define __TMPGROUP_OBJECT__HH

#include "config.h"

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Group.hh"
#include "fwbuilder/FWException.hh"

class TMPGroupObject : public libfwbuilder::Group 
{
    public:

    TMPGroupObject() : Group() { Hide(); }
    TMPGroupObject(const FWObject *root) : Group(root) { Hide(); }

    DECLARE_FWOBJECT_SUBTYPE(TMPGroupObject);

    virtual xmlNodePtr toXML      (xmlNodePtr xml_parent_node) throw(libfwbuilder::FWException);
    xmlNodePtr toXML(xmlNodePtr xml_parent_node, bool process_children) throw(libfwbuilder::FWException);

    virtual bool  validateChild(FWObject *o);

    virtual void    setDirty(bool f,bool recursive=false);
    virtual bool    isDirty(bool recursive);

};
#endif
