/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TableOfObjects.hh,v 1.12 2002/08/29 00:34:50 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef TABLEOFOBJECTS_HH
#define TABLEOFOBJECTS_HH

#include "config.h"

#include <vector>
#include <map>
#include <set>

#include <gtk--.h>

#include "fwbuilder/FWException.hh"

class ObjectDescriptor;
class TableOfObjects : public Gtk::Table {

    map<string,Gtk::CheckButton*>  v_c;
    map<string,Gtk::Widget*>       v_e;
    map<string,Gtk::Label*>        v_l;
    map<string,Gtk::HSeparator*>   v_s;
    map<string,const ObjectDescriptor*>  v_od;

    bool    using_combo;

    int     ncols,nrows;

    bool    filter_active;
    string  address_filter;
    string  name_filter;

    protected:

    int  addColumn(const string& title);
    virtual  void   filterByObjId(const string& obj_id, bool on);
    bool applyAddressFilter(const string& a1,const string& a_filter) 
	throw(libfwbuilder::FWException);
    bool applyNameFilter(const string& name,const string& n_filter) 
	throw(libfwbuilder::FWException);

    void on_changed();

    public:

    TableOfObjects(int nrows);

    void clear();

    virtual void addObject(int row,const string& obj_id,
			   const string& name,
			   const string& address,
			   const ObjectDescriptor *od=NULL);
    virtual void addObject(int row,const string& obj_id,
			   set<string> names,
			   const string& address,
			   const ObjectDescriptor *od=NULL);

    void   filter(const string& addr,const string& name);
    bool   isFilterActive()   { return filter_active;  }
    string getAddressFilter() { return address_filter; }
    string getNameFilter()    { return name_filter;    }

    bool                    isObjectChecked(const string& obj_id);
    string                  getObjectName(const string& obj_id);
    const ObjectDescriptor* getDescriptor(const string& obj_id);

    void   selectAll();
    void   unselectAll();
    int    getNumOfSelected();

    SigC::Signal0<void>changed;

};

#endif
