/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: fwbuilder.cc,v 1.109 2003/02/09 06:23:06 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif
/* internationalisation by f. manens */
#ifdef ENABLE_NLS
#include "gettext.h"
#define _(String) gettext (String)
#define gettext_noop(String) String
#define N_(String) gettext_noop (String)
#endif

#include <unistd.h>

#include <gtk--/main.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <glib.h>

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Tools.hh"
#include "fwbuilder/dns.hh"
#include "fwbuilder/XMLTools.hh"
#include "fwbuilder/Resources.hh"


#include "DialogFactory.hh"
#include "FWObjectDatabaseGUI.hh"
#include "helpers.hh"
#include "main_window.hh"
#include "FWObjectBook.hh"
#include "Preferences.hh"
#include "MessageDialog.hh"

#include "glademm_support.hh"

/* #include "fwbd/fwbd.h" */

#include <iostream>

#ifdef __MINGW32__
  #include <getopt.h>
  #include <winsock2.h>
#else
  #ifdef HAVE_GETOPT_H
    #include <getopt.h>
  #else
    #include <stdlib.h>
  #endif
#endif

using namespace libfwbuilder;

static string    filename;
static string    objid;
static main_window      *mw     = NULL;


#ifdef __MINGW32__
# define __FWB_ENTER	 gdk_threads_enter()
# define __FWB_LEAVE     WSACleanup(); \
 			 gdk_threads_leave(); \
			 __freeCommandLine(argc,argv)
#else
# define __FWB_ENTER
# define __FWB_LEAVE	gdk_threads_leave()
#endif

/**
 *   This handler gets called whenever gtk event loop is stopped via 
 *   Gtk::Main::quit()
 */

gint quit_handler()
{
    if (gtk_main_level()==1) {
// this is the  end of program


    }
    return true;
}

#ifdef __MINGW32__
void __parseCommandLine(string cmdline,int& argc, char**& argv)
{
  int pos = 0;
  argc = 1;
  argv = (char**)malloc(argc);
  char execFname[255];
  int sz = GetModuleFileName(GetModuleHandle(NULL),execFname,255);
  argv[0] = (char*)malloc(sz+1);
  strcpy(argv[0],execFname);

  while(pos != -1)
  {
       int p = cmdline.find_first_of(" ",pos);
       if (p == -1 && pos != cmdline.length() - 1)
           p = cmdline.length();
       if (p != -1)
       {
          argv = (char**)realloc(argv,++argc);
          char s[255];
	  int n = cmdline.copy(s,p - pos,pos);
          argv[argc-1] = (char*)malloc(n+1);
          strncpy(argv[argc-1],s,n);
          argv[argc-1][n+1] = '\0';
       }
       pos = cmdline.find_first_not_of(" ",p);
  }
}

void __freeCommandLine(int argc,char** argv)
{
  for (int i = 0; i < argc; i++)
     free(argv[argc]);
  free(argv);
}

void usage()
{

    MessageBox(NULL,_("Usage: fwbuilder [-?hv] [-f filename]"),_("Command line error"), MB_OK);


}
#else

void usage()
{

    cerr << _("Usage: fwbuilder [-?hv] [-f filename] [-o obj_id]\n");


}
#endif



#ifdef __MINGW32__

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,
		   LPSTR lpCmdLine,int nCmdShow )
#else

int main(int argc, char * const *argv)

#endif
 
{   
/*
 * I am using njamd a lot, but gtkmm and probably some other libs
 * generate trap in their global static initialization code. Therefore
 * I need to start the program with env. var. NJAMD_PROT set to "none"
 * and then reset it to something useful here.
 */
#ifdef HAVE_SETENV
    setenv("NJAMD_PROT","strict",1);
#else
#  ifdef HAVE_PUTENV
    putenv("NJAMD_PROT=strict");
#  endif
#endif

#ifdef ENABLE_NLS
    setlocale (LC_ALL, "");

    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain (PACKAGE);
#else
#  ifdef HAVE_SETLOCALE
    setlocale (LC_ALL, "");
#  endif
#endif

    /* see some more initializations below */    
    libfwbuilder::init();

    /* open-ssl related initializations */
    /* fwbd_init(); */

#ifdef __MINGW32__
     WORD wVersionRequested;
     WSADATA wsaData;

     wVersionRequested = MAKEWORD( 2, 2 );
     WSAStartup( wVersionRequested, &wsaData );

     int argc = 0;
     char** argv = NULL;
     __FWB_Instance = hInstance;
    __parseCommandLine(lpCmdLine,argc,argv);
#else
     gdk_threads_enter();
#endif

    Gtk::Main m(&argc, (char***)(&argv) , true );

#ifdef __MINGW32__
    gtk_rc_parse( TEMPLATE_DIR "/gtkrc.win" );
#else
    gtk_rc_parse( TEMPLATE_DIR "/gtkrc" );
#endif

    filename="";
    objid="";

    int c;
    while ((c = getopt (argc , argv , "?hvf:o:")) != EOF )
	switch (c) {
	case '?':
	case 'h':
	    usage();
	    exit(0);

	case 'f':
	    filename=optarg;
	    break;

	case 'o':
	    objid=optarg;
	    break;

	case 'v':
	    cout << VERSION << endl;
	    exit(0);
	}
    

/* pretty much everything else in the GUI uses resources, so we start here */
    try  
    {
        new Resources(TEMPLATE_DIR "/resources.xml");   // creates singleton Resources::global_res
    } catch(FWException &ex)  
    {
        /*
         *  Error loading resources. MessageDialog needs Resources (for
         *  icons), so we can't use it to show error message.  
         */
	cerr << ex.toString() << endl;
	__FWB_LEAVE;
        exit(1);
    }


    try  {
        new Preferences();     // creates singleton Preferences::global_prefs
    } catch(FWException &ex)  {
 	__FWB_ENTER;
	MessageDialog::Error(ex.toString(),NULL);
 	__FWB_LEAVE;
        exit(1);
    }

    try
    {
        libfwbuilder::init_dns();
        libfwbuilder::init_ssl();
    }
    catch(FWException &ex)  {
 	__FWB_ENTER;
	MessageDialog::Error(ex.toString(),NULL);
 	__FWB_LEAVE;
    }

    vector<std::string> platforms=Resources::getListOfPlatforms();
    if (platforms.empty() ||
        ( platforms.size()==1 && platforms.front()=="unknown" )
    )
    {
        MessageDialog::DlgReturnValue a = MessageDialog::YesNo(
_("Could not locate any modules for target firewall platforms.\n\
You won't be able to compile firewall policy.\n\
Do you want to continue?")
        );
        if (a!=MessageDialog::OK_YES) exit(1);
    }
   
    mw = new main_window();

    if ( Preferences::global_prefs->getOptBool(
	     "/FWBuilderPreferences/UI/RememberWindowPositionAndSize") ) {

	mw->restoreWindowConfiguration();
        mw->restoreWindowPosition();
    } 

    mw->show_all();

#ifdef __MINGW32__
    __fwb_win32_loadIcon("FWBuilderWin32Ico",mw);
#endif


    new FWObjectClipboard(); // creates singleton 
    new FWObjectDatabaseGUI();  // creates db

    try   {
	if(filename!="")  {
	    //load file given on command line
	    FWObjectDatabaseGUI::getInstance()->load(filename,true);
            main_window::setTitle( FWObjectDatabaseGUI::getInstance()->getFileName() );
            main_window::updateRecentlyOpenedFiles( FWObjectDatabaseGUI::getInstance()->getFileName() );
	} else  {
	    //load default file
	    string dbTemplateFile = 
		TEMPLATE_DIR  "/" + FWObjectDatabaseGUI::DB_TEMPLATE_FILE_NAME;
	    FWObjectDatabaseGUI::getInstance()->load(dbTemplateFile,false);
	    FWObjectDatabaseGUI::getInstance()->setFileName("");
	}
    } catch(FWException &ex)  {
 	__FWB_ENTER;
        string trans = ex.getProperties()["failed_transformation"];
        string elem  = ex.getProperties()["failed_element"];

        if(!trans.empty() || !elem.empty())
        {
            string msg = _("Exception: : ") + ex.toString();
            if(!trans.empty())
                msg+=_("\nFailed transformation : ") + trans;
            if(!elem.empty())
                msg+=_("\nXML element : ") + elem;

            MessageDialog::LongTextError(_("Error loading data file. "), msg, mw);
        } else
            MessageDialog::Error(_("Error loading data file. "), ex.toString(), mw);
 	__FWB_LEAVE;
	exit(1);
    }

    if (objid=="")  objid=FWObjectDatabaseGUI::getRootId();
    else {
        FWObject *o=FWObjectDatabaseGUI::db->getById(objid,true);
        while ( o!=NULL && ! DialogFactory::haveDialogFor(o) ) {
            o=o->getParent();
        }
        if (o!=NULL) objid=o->getId();
        else         objid=FWObjectDatabaseGUI::getRootId();
    }

    mw->getObjectBook()->build();
    mw->schedule_open_object(objid , "");

    Gtk::Main::quit.connect( SigC::slot( &quit_handler )  ) ;

    try
    {
        __FWB_ENTER;

        m.run();

        gdk_threads_leave();

    } catch (FWException &ex)  {
        cerr << ex.toString() << endl;
        return 1;
    } catch (std::string s) {
        cerr << s;
        return 1;
    } catch (std::exception ex) {
        cerr << ex.what();
        return 1;
    } catch (...) {
        cerr << _("Unsupported exception");
        return 1;
    }

    delete mw;
    delete Preferences::global_prefs;
    delete Resources::global_res;

    FWObjectDatabaseGUI::db->destroyChildren();
    delete FWObjectDatabaseGUI::db;

    delete FWObjectClipboard::obj_clipboard;

   __FWB_LEAVE;
    return 0;
}

