/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: gen_popup_menu.cc,v 1.7 2002/08/29 00:34:51 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "gen_popup_menu.hh"

#include <gtk--.h>


gen_popup_menu::gen_popup_menu(const char **i)
{
    using Gtk::Menu_Helpers::MenuElem;
    using Gtk::Menu_Helpers::SeparatorElem;
    using SigC::slot;

    const char     **cptr;
    Gtk::MenuItem  *mi;
    int             n;
    choice=-1;
    
    for (n=0,cptr=i; *cptr!=NULL; n++,cptr++)  {
	if (**cptr=='\0') {
	    items().push_back( SeparatorElem() );
//	    items().back()->set_sensitive(false);
	} else {
	    items().push_back( MenuElem(*cptr,
	     slot((gen_popup_menu*)this, &gen_popup_menu::on_item_activate)) );
	    mi=items().back();
	    mi->set_name(*cptr);
	    mi->set_user_data( (void*)n );
	}
	items().back()->show();
    }
    
    cancel.connect(slot((gen_popup_menu*)this, 
			&gen_popup_menu::on_menu_cancel));
    deactivate.connect(slot((gen_popup_menu*)this, 
			    &gen_popup_menu::on_menu_deactivate));
    show();
}

gen_popup_menu::~gen_popup_menu(){}

void gen_popup_menu::on_item_activate()
{
    Gtk::MenuItem *active_item = get_active();

    choice=(int)(active_item->get_user_data());

    Gtk::Main::quit();
    return;
}

int gen_popup_menu::run()
{
    Gtk::Main::grab_add(*this);
    Gtk::Main::run();
    Gtk::Main::grab_remove(*this);
    return choice;
}

void gen_popup_menu::on_menu_cancel()
{   
    choice=-1;
    Gtk::Main::quit();
}

void gen_popup_menu::on_menu_deactivate()
{   
    choice=-1;
    Gtk::Main::quit();
}

