/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: helpers.cc,v 1.52 2003/07/31 05:39:53 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "fwbuilder/libfwbuilder-config.h"

#include <gtk--.h>
#include <gtk--/packer.h> 
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <iostream>

#include "helpers.hh"
#include "fwbuilder/FWObjectDatabase.hh"
#include "MessageDialog.hh"
#include "main_window.hh"

#include <ctype.h>
#include <stdlib.h>
#include <sys/timeb.h>

#include "fwbuilder/XMLTools.hh"
#include "fwbuilder/IPAddress.hh"

#ifdef __MINGW32__
#include <gdk/win32/gdkwin32.h>
#endif

using namespace libfwbuilder;


/*
 *  call this function from main()
 *
void register_signals()
{

  gtk_signal_new("data_changed",
		 GTK_RUN_FIRST,
		 object_class->type,
		 GTK_SIGNAL_OFFSET( GtkCListClass , event ),
		 gtk_marshal_NONE__NONE,
		 GTK_TYPE_NONE, 0 );
}
*/


/*
GtkTargetEntry target_table[4] = {
  { "STRING",     0, PolicyList::TARGET_STRING },
  { "text/plain", 0, PolicyList::TARGET_STRING },
  { "text/uri-list", 0, PolicyList::TARGET_URL },
  { "application/x-rootwin-drop", 0, PolicyList::TARGET_ROOTWIN }
};
*/

GtkTargetEntry target_table[1] = {
  { "application/octet-stream", 0, TARGET_OBJ },
};

guint n_targets = sizeof(target_table) / sizeof(target_table[0]);

Gtk::Window* find_my_toplevel_window(Gtk::Widget *wp)
{
    return wp->get_toplevel();
}

/*
 *  Prints widgets tree starting from the given widget downwards
 */

Gtk::Widget* print_widget_tree(gint offset,Gtk::Widget *wp)
{
  if (wp==NULL) return (NULL);

  cerr << string(offset,' ') 
       << wp      << " "     << wp->get_name() 
       << " "     << " gtkobj="   << wp->gtkobj()
       << " is_visible=" << wp->is_visible()
       << " state="  << (int)(wp->get_state())
       << _(" style=")  << gtk_widget_get_style(GTK_WIDGET(wp->gtkobj()))
       << endl;

  if ( Gtk::MenuShell::isA( wp ) ) {
      Gtk::Menu_Helpers::MenuList itms=((Gtk::MenuShell*)wp)->items();
      Gtk::Menu_Helpers::MenuList::iterator m;
      for (m=itms.begin(); m!=itms.end(); ++m) {
	  print_widget_tree( offset+2, (*m) );
      }
      return(NULL);
  }

  if ( Gtk::MenuItem::isA( wp ) ) {
      print_widget_tree( offset+2, ((Gtk::Bin*)wp)->get_child() );
      Gtk::Menu *sm=((Gtk::MenuItem*)wp)->get_submenu();
      if (sm)
	  print_widget_tree( offset+2, sm );
      return(NULL);
  }


  if ( Gtk::Bin::isA( wp ) ) {
    print_widget_tree( offset+2, ((Gtk::Bin*)wp)->get_child() );
    return(NULL);
  }

  if ( Gtk::Box::isA( wp ) ) {
    Gtk::Box      *bptr=(Gtk::Box*)wp;
    Gtk::Box_Helpers::BoxList   bl= bptr->children();
    Gtk::Box_Helpers::BoxList::iterator bl_i;
    Gtk::Box_Helpers::Child    *ch;
    
    for (bl_i=bl.begin(); bl_i!=bl.end(); bl_i++) {
      ch= *bl_i;
      print_widget_tree( offset+2 , ch->get_widget());
    }
    return(NULL);
  }

  if ( Gtk::Packer::isA(wp) ) {
    Gtk::Packer      *bptr=(Gtk::Packer*)wp;
    Gtk::Packer_Helpers::PackerList   bl= bptr->children();
    Gtk::Packer_Helpers::PackerList::iterator bl_i;
    Gtk::Packer_Helpers::Child    *ch;
    
    for (bl_i=bl.begin(); bl_i!=bl.end(); bl_i++) {
      ch= *bl_i;
      print_widget_tree( offset+2 , ch->get_widget());
    }
    return(NULL);
  }

  if ( Gtk::Notebook::isA(wp) ) {
    for (int i=0; i<10; ++i)
      print_widget_tree( offset+2,((Gtk::Notebook*)wp)->get_nth_page(i) );
    return(NULL);
  }

  if ( Gtk::Paned::isA(wp) ) {
    print_widget_tree( offset+2,
		       ((Gtk::Paned*)wp)->get_child1());
    print_widget_tree( offset+2,
		       ((Gtk::Paned*)wp)->get_child2());
    return(NULL);
  }

  if ( Gtk::Table::isA( wp ) ) {
    Gtk::Table_Helpers::TableList tbl=((Gtk::Table*)wp)->children();
    Gtk::Table_Helpers::TableList::iterator m;
    for (m=tbl.begin(); m!=tbl.end(); ++m) {
      print_widget_tree( offset+2,(*m));
    }
    return(NULL);
  }

  return(NULL);
}


static Gtk::Widget* find_widget_helper(const char *wname,Gtk::Widget *wp)
{
  Gtk::Widget *nwp;

//    cout << _("find_widget: wp=") << wp << 
//      "  wp->get_name()=" << wp->get_name() << 
//      "  wname=" << wname << " \n";

  if (wp==NULL) return (NULL);

  if (wp->get_name() == wname)  return wp;

  if ( Gtk::MenuShell::isA( wp ) ) {
      Gtk::Menu_Helpers::MenuList itms=((Gtk::MenuShell*)wp)->items();
      Gtk::Menu_Helpers::MenuList::iterator m;
      for (m=itms.begin(); m!=itms.end(); ++m) {
	  nwp=find_widget_helper( wname , (*m) );
	  if (nwp) return(nwp);
      }
      return(NULL);
  }

  if ( Gtk::MenuItem::isA( wp ) ) {
      nwp=find_widget_helper( wname , ((Gtk::Bin*)wp)->get_child() );
      if (nwp) return(nwp);
      Gtk::Menu *sm=((Gtk::MenuItem*)wp)->get_submenu();
      if (sm)
	  nwp=find_widget_helper( wname , sm );
      return(nwp);
  }



  if ( Gtk::Bin::isA( wp ) ) {
    nwp=find_widget_helper( wname , ((Gtk::Bin*)wp)->get_child() );
    return(nwp);
  }
  if ( Gtk::Box::isA( wp ) ) {
    Gtk::Box      *bptr=(Gtk::Box*)wp;
    Gtk::Box_Helpers::BoxList   bl= bptr->children();
    Gtk::Box_Helpers::BoxList::iterator bl_i;
    Gtk::Box_Helpers::Child    *ch;
    
    for (bl_i=bl.begin(); bl_i!=bl.end(); bl_i++) {
      ch= *bl_i;
      if ((nwp=find_widget_helper(wname,ch->get_widget()))!=0) 
	return(nwp);
    }
  }
  if ( Gtk::Packer::isA(wp) ) {
    Gtk::Packer      *bptr=(Gtk::Packer*)wp;
    Gtk::Packer_Helpers::PackerList   bl= bptr->children();
    Gtk::Packer_Helpers::PackerList::iterator bl_i;
    Gtk::Packer_Helpers::Child    *ch;
    
    for (bl_i=bl.begin(); bl_i!=bl.end(); bl_i++) {
      ch= *bl_i;
      if ((nwp=find_widget_helper(wname,ch->get_widget()))!=0) 
	return(nwp);
    }
  }
  if ( Gtk::Notebook::isA(wp) ) {
    for (int i=0; i<10; ++i)
      if ((
	   nwp=find_widget_helper( wname,
				  ((Gtk::Notebook*)wp)->get_nth_page(i) )
	   )!=0)  return(nwp);
    return(NULL);
  }

  if ( Gtk::Paned::isA(wp) ) {
    if ((nwp=find_widget_helper(wname,
			((Gtk::Paned*)wp)->get_child1()))!=0) return(nwp);
    if ((nwp=find_widget_helper(wname,
			((Gtk::Paned*)wp)->get_child2()))!=0) return(nwp);
  }
  return(NULL);
}





Gtk::Widget* find_widget(const char *wname,Gtk::Widget *awp)
{
  Gtk::Widget *wp=awp;

  wp=awp->get_toplevel();
  return ( find_widget_helper(wname,wp) );
}

/*****************************************************************/

static Gtk::Widget* find_gtk_widget_helper(GtkWidget *gtkobj,Gtk::Widget *wp)
{
  Gtk::Widget *nwp;
 
  //  cout << "find_widget: wp=" << wp << 
  //          "  wp->gtkobj()=" << wp->gtkobj() << 
  //          "  gtkobj=" << gtkobj << endl;


  if (wp==NULL) return (NULL);

  if (wp->gtkobj() == gtkobj)  return wp;

  if ( GTK_IS_BIN( wp->gtkobj() ) ) {
    nwp=find_gtk_widget_helper( gtkobj , ((Gtk::Bin*)wp)->get_child() );
    return(nwp);
  }
  if ( GTK_IS_BOX( wp->gtkobj() ) ) {
    Gtk::Box      *bptr=(Gtk::Box*)wp;
    Gtk::Box_Helpers::BoxList   bl= bptr->children();
    Gtk::Box_Helpers::BoxList::iterator bl_i;
    Gtk::Box_Helpers::Child    *ch;
    
    for (bl_i=bl.begin(); bl_i!=bl.end(); bl_i++) {
      ch= *bl_i;
      nwp=find_gtk_widget_helper( gtkobj ,  ch->get_widget() );
      if (nwp!=NULL) return(nwp);
    }
  }
  return(NULL);
}





Gtk::Widget* find_gtk_widget(GtkWidget *gtkobj,Gtk::Widget *awp)
{
  Gtk::Widget *wp=awp;

  wp=awp->get_toplevel();
  return ( find_gtk_widget_helper(gtkobj,wp) );
}


void  setButtonLblAlignment(Gtk::Button *btn, gfloat x, gfloat y)
{
    ((Gtk::Label*)(btn->get_child()))->set_alignment(x,y);
}

Gtk::Menu* createOptionsMenu( vector<string> &items , 
			      string &active_item,
			      SigC::Slot0<void> callback)
{
    Gtk::Menu     *_m(manage(new Gtk::Menu()));
    Gtk::MenuItem *_mi;
    int             n, ind=0;
    vector<string>::iterator i;

    for (n=0,i=items.begin(); i!=items.end(); ++i,++n) {
	_mi = manage(new Gtk::MenuItem( (*i) ));
	_m->append(*_mi);
	_mi->show();
	_mi->set_user_data((gpointer) &(*i) );
//	if (callback!=NULL) _mi->activate_item.connect(callback);

	if ((*i)==active_item) ind=n;
    }
    _m->set_active( ind );

    if (callback!=NULL) _m->selection_done.connect(callback);

    return _m;
}

Gtk::Menu *createOptionsMenu( map<string,string> &items , 
			      string &active_item,
			      SigC::Slot0<void> callback )
{
    Gtk::Menu     *_m(manage(new Gtk::Menu()));
    Gtk::MenuItem *_mi;
    int             n, ind=0;
    map<string,string>::iterator i;

    for (n=0,i=items.begin(); i!=items.end(); ++i,++n) {
	_mi = manage(new Gtk::MenuItem( (*i).first ));
	_m->append(*_mi);
	_mi->show();
	_mi->set_user_data((gpointer) &((*i).second) );

	if ( (*i).second == active_item ) ind=n;
    }
    _m->set_active( ind );

    if (callback!=NULL) _m->selection_done.connect(callback);

    return _m;
}



void widgetModifyFont (Gtk::Widget   *widget,
		       gchar         *fontset_name)
{
    GtkWidget *w;
    GtkStyle  *new_style;
    GdkFont   *font;

    w=widget->gtkobj();

    g_return_if_fail (GTK_IS_WIDGET (w));
    g_return_if_fail (fontset_name != NULL);


    if ( (font=gdk_font_load (fontset_name))!=NULL )
    {
        gtk_widget_ensure_style (w);
        new_style = gtk_style_copy (w->style);
        gdk_font_unref (new_style->font);
        new_style->font = font;
        gtk_widget_set_style (w, new_style);
    }
}




/**
 *    this function checks object name syntax validity
 *
 *    Once we've made attribute 'name' to be of type CDATA, there are no
 *    limitations on its content left
 */
void  checkObjectName(const string& name) throw(libfwbuilder::FWException)
{
    return;
}

/**
 *    this function checks correctness of IP address 
 */
void checkIPaddress(const string& s) throw(libfwbuilder::FWException)
{
    IPAddress a;
    a=s;
    return;
}

/**
 *    this function checks correctness of a netmask
 */
void checkNetmask(const string& s) throw(libfwbuilder::FWException)
{
    Netmask a;
    a=s;
    return;
}

/**
 *  MAC address consists of 6 octets, separated with ':'
 */
void  checkMACAddress(const string& MACAddress) throw(libfwbuilder::FWException)
{
    int   n1,n2,n3,n4,n5,n6;
    char  rest[256];

    n1=n2=n3=n4=n5=n6=-1;
    rest[0]='\0';

    int n=sscanf(MACAddress.c_str(),
		 "%02x:%02x:%02x:%02x:%02x:%02x%s",
		 &n1,&n2,&n3,&n4,&n5,&n6,rest);

    if (n!=6 
	|| n1<0 || n1>255
	|| n2<0 || n2>255
	|| n3<0 || n3>255
	|| n4<0 || n4>255
	|| n5<0 || n5>255
	|| n6<0 || n6>255
	|| rest[0]!='\0' ) {

	throw FWException(_("Invalid MAC address.\nMAC address consists of 6 octets, separated with ':'") );
    }
    return;
}


FWObject* _findObjectByName(const string &tree_id, const string &name,
			    bool match_case,
			    bool partial_match)
{
    FWObject *tree=FWObjectDatabase::db->getById(tree_id,true);
    return _findObjectByName(tree , name , match_case , partial_match);
}


FWObject* _findObjectByName(FWObject *tree, const string &name,
			    bool match_case,
			    bool partial_match)
{
    char str1[256], str2[256], *c;
    strncpy(str1,name.c_str(),sizeof(str1));

    if (!match_case) {
	for (c=str1; *c; c++) *c=tolower(*c);
    }

    if(!tree)
        return NULL;

    if(name==tree->getName())
        return tree;
    
    for(list<FWObject*>::iterator j=tree->begin(); j!=tree->end(); ++j)     
    {
        FWObject *o;
        if((o=(*j))!=NULL)   
        {
            string oname=o->getName();
	    strncpy(str2,oname.c_str(),sizeof(str2));
	    if (!match_case) {
		for (c=str2; *c; c++) *c=tolower(*c);
	    }

	    if (partial_match) {
		if (strstr(str2,str1)==str2)  return o;
	    } else {
		if (strcmp(str1,str2)==0)     return o;
	    }

	    o=_findObjectByName(o, name, match_case, partial_match);
	    if(o) 
                return o;
            
        }
    }
    return NULL; // not found
}


#ifdef __MINGW32__

void   __fwb_win32_loadIcon(string iname,Gtk::Widget* widget)
{
    HICON hIcon = ExtractIcon(__FWB_Instance,Resources::global_res->getIconPath(iname.c_str()).c_str(),0);
    HWND hWnd = (HWND)GDK_WINDOW_XWINDOW(widget->gtkobj()->window);
    SendMessage(hWnd, WM_SETICON, TRUE, (LPARAM)hIcon);     
}

void __fwb_win32_loadIcon(string iname,Gtk::Window* window)
{
    __fwb_win32_loadIcon(iname,((Gtk::Widget*)window));
}

string __fwb_win32_getWinDir()
{
  char pathBuf[MAX_PATH+1];
  GetWindowsDirectory(pathBuf,MAX_PATH);
  return string(pathBuf);
}

string __fwb_win32_getCurrentProfileDir()
{
    char* envVar = getenv("USERPROFILE");
    if (!envVar)
      return string("");

    return (string(envVar));
}

#endif
