/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: main_window_menu.cc,v 1.44 2002/12/26 07:02:02 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <config.h>
#include "main_window.hh"

using namespace libfwbuilder;


void main_window::build_menu()
{
    using Gtk::Menu_Helpers::MenuElem;
    using Gtk::Menu_Helpers::SeparatorElem;
    using SigC::slot;
    using SigC::bind;
    
    using namespace Gtk;

    Gtk::Menu *file_menu=manage(new Menu() );


    file_menu->items().push_back(MenuElem(_("_New"),
		       slot(this, &main_window::on_new1_activate) ) );

    file_menu->items().push_back(MenuElem(_("New _Window"), "<control>N",
		       slot(this, &main_window::on_new_wnd_activate) ) );

    file_menu->items().push_back(MenuElem(_("_Open"), "<control>O",
		       slot(this, &main_window::on_open1_activate) ) );

    file_menu->items().push_back(MenuElem(_("_Save"), "<control>S",
		       slot(this, &main_window::on_save1_activate) ) );

    file_menu->items().push_back(MenuElem(_("Save _As"), "<control>A",
		       slot(this, &main_window::on_saveas1_activate) ) );

    file_menu->items().push_back( SeparatorElem());


    file_menu->items().push_back(MenuElem(_("_Print"), "<control>P",
		       slot(this, &main_window::on_print_activate) ) );

    file_menu->items().push_back( SeparatorElem());


    recent_files_menu=manage(new Menu() );
/* "Open Recent" is empty at this point */

    file_menu->items().push_back(MenuElem(_("Open _Recent"), *recent_files_menu) );

    file_menu->items().push_back( SeparatorElem());

    file_menu->items().push_back(MenuElem(_("_Close"),"<control>W",
		       slot(this, &main_window::on_close_activate) ) );

    file_menu->items().push_back(MenuElem(_("E_xit"),"<control>Q",
		       slot(this, &main_window::on_exit1_activate) ) );

    Gtk::Menu *new_menu=manage(new Menu() );


    new_menu->items().push_back( MenuElem(_("Firewall"),
			      slot(this, &main_window::on_new_fw) ) );

    new_menu->items().push_back( MenuElem(_("Host"),
			      slot(this, &main_window::on_new_host) ) );

    new_menu->items().push_back( MenuElem(_("Network"),
			      slot(this, &main_window::on_new_net) ) );

    new_menu->items().push_back( MenuElem(_("Address Range"),
			      slot(this, &main_window::on_new_addr_range) ) );

    new_menu->items().push_back( MenuElem(_("Group of Objects"),
		       slot(this, &main_window::on_new_obj_group) ) );

    new_menu->items().push_back( SeparatorElem());

    new_menu->items().push_back( MenuElem(_("IP"),
			      slot(this, &main_window::on_new_ip) ) );

    new_menu->items().push_back( MenuElem(_("ICMP"),
			      slot(this, &main_window::on_new_icmp) ) );

    new_menu->items().push_back( MenuElem(_("TCP"),
			      slot(this, &main_window::on_new_tcp) ) );

    new_menu->items().push_back( MenuElem(_("UDP"),
			      slot(this, &main_window::on_new_udp) ) );

    new_menu->items().push_back( MenuElem(_("Custom Service"),
			      slot(this, &main_window::on_new_custom) ) );

    new_menu->items().push_back( MenuElem(_("Group of Services"),
		       slot(this, &main_window::on_new_srv_group) ) );

    new_menu->items().push_back( SeparatorElem());

    new_menu->items().push_back( MenuElem(_("Time"),
			      slot(this, &main_window::on_new_time) ) );

    new_menu->items().push_back( SeparatorElem());

    new_menu->items().push_back( MenuElem(_("Interface"),
			      slot(this, &main_window::on_new_interface) ) );
    new_menu->items().back()->set_name("insert_interface");
    new_menu->items().back()->set_sensitive(false);

    new_menu->items().push_back( MenuElem(_("get Interfaces via SNMP"),
			      slot(this, &main_window::on_new_interface_via_snmp) ) );
    new_menu->items().back()->set_name("insert_interface_via_snmp");
    new_menu->items().back()->set_sensitive(false);

    new_menu->items().push_back( SeparatorElem());

    new_menu->items().push_back( MenuElem(_("Address"),
			      slot(this, &main_window::on_new_ipv4) ) );
    new_menu->items().back()->set_name("insert_ipv4");
    new_menu->items().back()->set_sensitive(false);

    new_menu->items().push_back( MenuElem(_("Physical Address"),
			      slot(this, &main_window::on_new_physaddress) ) );
    new_menu->items().back()->set_name("insert_physaddress");
    new_menu->items().back()->set_sensitive(false);




    Menu *edit_menu=manage(new Menu() );

    edit_menu->items().push_back( MenuElem(_("Duplicate Object"),"",
			      slot(this, &main_window::on_duplicate) ) );

    edit_menu->items().back()->set_name("duplicate");
    edit_menu->items().back()->set_sensitive(false);


    edit_menu->items().push_back( MenuElem(_("Copy Object"),"",
			      slot(this, &main_window::on_copyobj) ) );

    edit_menu->items().back()->set_name("copy");
    edit_menu->items().back()->set_sensitive(false);

    edit_menu->items().push_back( MenuElem(_("Cut Object"),"",
			      slot(this, &main_window::on_cutobj) ) );

    edit_menu->items().back()->set_name("cut");
    edit_menu->items().back()->set_sensitive(false);

    edit_menu->items().push_back( MenuElem(_("Paste Object"),"",
			      slot(this, &main_window::on_pasteobj) ) );

    edit_menu->items().back()->set_name("paste");
    edit_menu->items().back()->set_sensitive(false);

    edit_menu->items().push_back( MenuElem(_("Delete Object"),"",
			      slot(this, &main_window::on_delobj) ) );

    edit_menu->items().back()->set_name("delete");
    edit_menu->items().back()->set_sensitive(false);

    edit_menu->items().push_back( SeparatorElem());

    edit_menu->items().push_back( MenuElem(_("Copy"),"",
			      slot(this, &main_window::on_copy) ) );

    edit_menu->items().back()->set_name("copy-cpb");
    edit_menu->items().back()->set_sensitive(true);

    edit_menu->items().push_back( MenuElem(_("Cut"),"",
			      slot(this, &main_window::on_cut) ) );

    edit_menu->items().back()->set_name("cut-cpb");
    edit_menu->items().back()->set_sensitive(true);

    edit_menu->items().push_back( MenuElem(_("Paste"),"",
			      slot(this, &main_window::on_paste) ) );

    edit_menu->items().back()->set_name("paste-cpb");
    edit_menu->items().back()->set_sensitive(true);

    edit_menu->items().push_back( SeparatorElem());

    edit_menu->items().push_back( MenuElem(_("Sort subtree by name"),"<control>T",
			      slot(this, &main_window::on_sort_by_name) ) );
    edit_menu->items().back()->set_name("sort_by_name");
    edit_menu->items().back()->set_sensitive(false);

    edit_menu->items().push_back( MenuElem(_("Sort subtree by properties"),"",
			      slot(this, &main_window::on_sort_by_prop) ) );
    edit_menu->items().back()->set_name("sort_by_prop");
    edit_menu->items().back()->set_sensitive(false);

    edit_menu->items().push_back( SeparatorElem());

    edit_menu->items().push_back( MenuElem(_("Options"),
	      slot(this, &main_window::on_options_activate) ) );

    Menu *view_menu=manage(new Menu() );
/*
 *  use MenuElem without accelerator string so that get_child will
 *  return Label later. We use that to change menu item label text. --vk
 */

//    view_menu->items().push_back( MenuElem(_("Float Object Dialog"),


//			      slot(this, &main_window::on_float_pane) ) );
//    view_menu->items().back()->set_name("float_pane");
//    view_menu->items().back()->set_sensitive(true);
//    view_menu->items().back()->configure(true,false);

    view_menu->items().push_back( SeparatorElem());

    view_menu->items().push_back( MenuElem(_("_Find Object"),"<control>F",
			      slot(this, &main_window::on_find) ) );

    view_menu->items().back()->set_name("find");
    view_menu->items().back()->set_sensitive(true);

    view_menu->items().push_back( SeparatorElem());

    view_menu->items().push_back( MenuElem(_("_Where used"),"",
			      slot(this, &main_window::on_where_used) ) );

    view_menu->items().back()->set_name("where_used");
    view_menu->items().back()->set_sensitive(true);


    Menu *policy_menu=manage( new Menu() );

    policy_menu->set_name("policy_menu");

    policy_menu->items().push_back( MenuElem(_("Insert rule on the top"),
	       slot(this,&main_window::on_insert_top)) );

    policy_menu->items().back()->set_name("insert_top");

    policy_menu->items().push_back( MenuElem(_("Append rule at the bottom"),
	       slot(this,&main_window::on_append_bottom)) );

    policy_menu->items().back()->set_name("append_bottom");

    policy_menu->items().push_back( MenuElem(_("Add rule after current"),
	       slot(this,&main_window::on_add_rule)) );

    policy_menu->items().back()->set_name("add_after");

    policy_menu->items().push_back( MenuElem(_("Remove current rule"),
	       slot(this,&main_window::on_remove_rule)) );

    policy_menu->items().back()->set_name("remove_current");

    policy_menu->items().push_back( MenuElem(_("Move rule up"),
	       slot(this,&main_window::on_move_up)) );

    policy_menu->items().back()->set_name("move_up");

    policy_menu->items().push_back( MenuElem(_("Move rule down"),
	       slot(this,&main_window::on_move_down)) );

    policy_menu->items().back()->set_name("move_down");

    policy_menu->items().push_back( SeparatorElem());

    policy_menu->items().push_back( MenuElem(_("Help me build firewall policy"),
	       slot(this,&main_window::on_build_autorules)) );

    policy_menu->items().back()->set_name("rules_druid");

    policy_menu->items().push_back( SeparatorElem());

    policy_menu->items().push_back( MenuElem(_("Compile"),
	       slot(this,&main_window::on_compile)) );

    policy_menu->items().back()->set_name("compile_policy");

    policy_menu->items().push_back( MenuElem(_("Install"),
	       slot(this,&main_window::on_install)) );

    policy_menu->items().back()->set_name("install_policy");

    Menu *tools_menu=manage( new Menu() );

    tools_menu->set_name("tools_menu");


    tools_menu->items().push_back( MenuElem(_("Discover Objects"),
	       slot(this,&main_window::on_tools_scan)) );

    tools_menu->items().back()->set_name("scan");

    tools_menu->items().back()->set_sensitive(true);


    Menu *help_menu=manage( new Menu() );


    help_menu->items().push_back(MenuElem(_("About"),
               slot(this,&main_window::on_about1_activate)) );
/*
    help_menu->items().push_back( SeparatorElem());


    help_menu->items().push_back(MenuElem(_("Release Notes"),


               slot(this,&main_window::on_release_notes_activate)) );
*/

    main_menubar1->items().push_back( MenuElem(_("_File"),  
					       "<Alt>F",
					       *file_menu ) );
    main_menubar1->items().back()->set_name("file");

    main_menubar1->items().push_back( MenuElem(_("_Edit"),  
					       "<Alt>E", 
					       *edit_menu ) );
    main_menubar1->items().back()->set_name("edit");

    main_menubar1->items().push_back( MenuElem(_("_View"),  
					       "<Alt>V", 
					       *view_menu ) );
    main_menubar1->items().back()->set_name("edit");

    main_menubar1->items().push_back( MenuElem(_("_Insert"),  
					       "<Alt>I", 
					       *new_menu ) );
    main_menubar1->items().back()->set_name("new");

    main_menubar1->items().push_back( MenuElem(_("_Rules"),
					       "<Alt>R", 
					       *policy_menu ) );
    main_menubar1->items().back()->set_name("policy");
    main_menubar1->items().back()->set_sensitive(false);

    main_menubar1->items().push_back( MenuElem(_("_Tools"),
					       _("<Alt>T"), 
					       *tools_menu ) );
    main_menubar1->items().back()->set_name("tools");

    main_menubar1->items().push_back( MenuElem(_("_Help"),  
					       _("<Alt>H"), 
					       *help_menu ) );

    main_menubar1->items().back()->right_justify();
    main_menubar1->items().back()->set_name("help");

    updateRecentlyOpenedFiles("");
}

void main_window::updateRecentlyOpenedFiles(const string &new_file)
{
    using Gtk::Menu_Helpers::MenuElem;
    using Gtk::Menu_Helpers::SeparatorElem;

    string f1=Preferences::global_prefs->getOptStr("/FWBuilderPreferences/History/File1");
    string f2=Preferences::global_prefs->getOptStr("/FWBuilderPreferences/History/File2");
    string f3=Preferences::global_prefs->getOptStr("/FWBuilderPreferences/History/File3");
    string f4=Preferences::global_prefs->getOptStr("/FWBuilderPreferences/History/File4");

    if (new_file!="" &&
        new_file!=f1 &&
        new_file!=f2 &&
        new_file!=f3 &&
        new_file!=f4 )
    {
        f4=f3;
        f3=f2;
        f2=f1;
        f1=new_file;

        Preferences::global_prefs->setOpt("/FWBuilderPreferences/History/File1",f1);
        Preferences::global_prefs->setOpt("/FWBuilderPreferences/History/File2",f2);
        Preferences::global_prefs->setOpt("/FWBuilderPreferences/History/File3",f3);
        Preferences::global_prefs->setOpt("/FWBuilderPreferences/History/File4",f4);
    }

    string::size_type ls;

    if ( (ls=f1.rfind("/"))!=string::npos) f1=f1.substr(ls+1);
    if ( (ls=f2.rfind("/"))!=string::npos) f2=f2.substr(ls+1);
    if ( (ls=f3.rfind("/"))!=string::npos) f3=f3.substr(ls+1);
    if ( (ls=f4.rfind("/"))!=string::npos) f4=f4.substr(ls+1);

    for (list<main_window*>::iterator i=windows.begin(); i!=windows.end(); ++i) 
    {
        main_window *mw=(*i);

        mw->recent_files_menu->items().clear();

        if (f1!="")  mw->recent_files_menu->items().push_back(MenuElem("_1: "+f1, "<control>1",
                     slot(mw, &main_window::on_open_recent_file1_activate) ) );
 
        if (f2!="")  mw->recent_files_menu->items().push_back(MenuElem("_2: "+f2, "<control>2",
                     slot(mw, &main_window::on_open_recent_file2_activate) ) );
 
        if (f3!="")  mw->recent_files_menu->items().push_back(MenuElem("_3: "+f3, "<control>3",
                     slot(mw, &main_window::on_open_recent_file3_activate) ) );
 
        if (f4!="")  mw->recent_files_menu->items().push_back(MenuElem("_4: "+f4, "<control>4",
                     slot(mw, &main_window::on_open_recent_file4_activate) ) );
    }
}

