/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PolicyCompiler_ipt_optimizer.cc,v 1.13 2003/10/25 23:52:19 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "PolicyCompiler_ipt.hh"

#include "fwbuilder/FWObjectDatabase.hh"
#include "fwbuilder/RuleElement.hh"
#include "fwbuilder/IPService.hh"
#include "fwbuilder/ICMPService.hh"
#include "fwbuilder/TCPService.hh"
#include "fwbuilder/UDPService.hh"
#include "fwbuilder/Policy.hh"

#include "combinedAddress.hh"

#include <limits.h>

#include <iostream>
#include <iomanip>
#include <sstream>

#include <assert.h>

using namespace libfwbuilder;
using namespace fwcompiler;
using namespace std;


void PolicyCompiler_ipt::optimize1::optimizeForRuleElement(PolicyRule         *rule, 
                                                           const std::string  &re_type)
{
    RuleElement    *re=RuleElement::cast(rule->getFirstByType(re_type));
    int nre=re->size();

    PolicyRule     *r;

    string new_chain=PolicyCompiler_ipt::getNewTmpChainName(rule);

    r= PolicyRule::cast(compiler->dbcopy->create(PolicyRule::TYPENAME,true) );
    compiler->temp_ruleset->add(r);
    r->duplicate(rule);

    for (FWObject::iterator i=r->begin(); i!=r->end(); ++i)
    {
        if (RuleElement::cast(*i)!=NULL && (*i)->getTypeName()!=re_type)
        {
            RuleElement *nre=RuleElement::cast(*i);
            nre->clearChildren();  
            nre->setAnyElement();
        }
    }
    r->setStr("ipt_target",new_chain);
    tmp_queue.push_back(r);

    rule->setStr("ipt_chain",new_chain);
    re->clearChildren();  
    re->setAnyElement();
    tmp_queue.push_back(rule);
}

bool PolicyCompiler_ipt::optimize1::processNext()
{
    PolicyRule *rule=getNext(); if (rule==NULL) return false;

    RuleElementSrc *srcrel=rule->getSrc();
    RuleElementDst *dstrel=rule->getDst();
    RuleElementSrv *srvrel=rule->getSrv();

    int srcn=srcrel->size();
    int dstn=dstrel->size();
    int srvn=srvrel->size();

    if ( (srcn==1 && dstn==1) ||
         (dstn==1 && srvn==1) ||
         (srvn==1 && srcn==1) )
    {
        tmp_queue.push_back(rule);
        return true;
    }

    if (srcn==1) srcn=INT_MAX;
    if (dstn==1) dstn=INT_MAX;
    if (srvn==1) srvn=INT_MAX;

    string re=RuleElementSrc::TYPENAME;

    if (srcn<=dstn && dstn<=srvn)
    {
        optimizeForRuleElement(rule,RuleElementSrc::TYPENAME);
        return true;
    }

    if (dstn<=srvn && srvn<=srcn)
    {
        optimizeForRuleElement(rule,RuleElementDst::TYPENAME);
        return true;
    }

    if (srvn<=srcn && srcn<=dstn)
    {
        optimizeForRuleElement(rule,RuleElementSrv::TYPENAME);
        return true;
    }


    tmp_queue.push_back(rule);

    return true;
}

bool PolicyCompiler_ipt::optimize2::processNext()
{
    PolicyCompiler_ipt *ipt_comp=dynamic_cast<PolicyCompiler_ipt*>(compiler);
    PolicyRule *rule=getNext(); if (rule==NULL) return false;

    RuleElementSrv *srvrel=rule->getSrv();

    if (rule->getBool("final"))
    {
        if ( rule->getAction()==PolicyRule::Reject && ipt_comp->isActionOnRejectTCPRST(rule))
        {
// preserve service
            ;
        } else 
        {
            srvrel->clearChildren();
            srvrel->setAnyElement();
        }
    }

    tmp_queue.push_back(rule);

    return true;
}

/*
 *  this processor eliminates duplicate rules _generated for the same high level rule_
 *  This is different from processor PolicyCompiler_ipf::eliminateDuplicateRules, which
 *  finds and eliminates duplicate rules throughout the whole generated script.
 */
bool PolicyCompiler_ipt::optimize3::processNext()
{
    PolicyRule *rule;
    rule=getNext(); if (rule==NULL) return false;

    if (rule->isFallback() || rule->isHidden())
    {
        tmp_queue.push_back(rule);
        return true;
    }

    if (printRule==NULL)
    {
        printRule=new PrintRule("");
        printRule->setContext(compiler);
    }
    string thisRule = rule->getLabel() + " " + printRule->PolicyRuleToString(rule);
    if (rules_seen_so_far.count(thisRule)!=0) return true;

    tmp_queue.push_back(rule);
    rules_seen_so_far[thisRule]=true;

    return true;
}
