/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TargetDialog_freebsd.cc,v 1.7 2002/09/28 17:34:58 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "TargetDialog_freebsd.hh"
#include "fwbuilder/Resources.hh"

#include "fwbuilder/Firewall.hh"

using namespace libfwbuilder;

DialogPlugin* create_dialog_freebsd(FWObject *o)
{
    return new TargetDialog_freebsd(o);
}


TargetDialog_freebsd::TargetDialog_freebsd(FWObject *obj) 
{ 
    object=obj;

    fwoptions=(Firewall::cast(object))->getOptionsObject();
    assert(fwoptions!=NULL);

    map<string,string>        on_off_menu;
    on_off_menu["1"]=_("On");
    on_off_menu["0"]=_("Off");
    on_off_menu[DialogPlugin::magic_empty_option]=_("No change");


    freebsd_ip_forward->set_menu(on_off_menu);
    freebsd_ip_forward->changed.connect(SigC::slot(this,&TargetDialog_freebsd::on_changed));
    freebsd_ip_forward->show_all();

    freebsd_ip_sourceroute->set_menu(on_off_menu);
    freebsd_ip_sourceroute->changed.connect(SigC::slot(this,&TargetDialog_freebsd::on_changed));
    freebsd_ip_sourceroute->show_all();

    freebsd_ip_redirect->set_menu(on_off_menu);
    freebsd_ip_redirect->changed.connect(SigC::slot(this,&TargetDialog_freebsd::on_changed));
    freebsd_ip_redirect->show_all();

    options.push_back( DialogOption(  freebsd_ip_forward            , "freebsd_ip_forward"));
    options.push_back( DialogOption(  freebsd_ip_sourceroute        , "freebsd_ip_sourceroute"));
    options.push_back( DialogOption(  freebsd_ip_redirect           , "freebsd_ip_redirect"));

    options.push_back( DialogOption(  freebsd_path_ipf  , "freebsd_path_ipf"));
    options.push_back( DialogOption(  freebsd_path_ipnat, "freebsd_path_ipnat"));
    options.push_back( DialogOption(  freebsd_path_sysctl,"freebsd_path_sysctl"));
}

void TargetDialog_freebsd::on_changed()
{   
    DialogPlugin::data_changed_flag(true);
}

void TargetDialog_freebsd::readDefaults()
{
    freebsd_ip_forward->set_active_item_by_label(
        Resources::os_res["freebsd"]->getResourceStr(
            "/FWBuilderResources/Target/options/freebsd_ip_forward"));
}

void TargetDialog_freebsd::wrk2dlg()
{
    loadPageOptions(fwoptions,  options);
}

bool TargetDialog_freebsd::dlg2wrk()
{
    savePageOptions(fwoptions,  options );
    return true;
}
