/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TargetDialog_pf.cc,v 1.16 2003/12/14 22:36:16 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "fwbuilder/Firewall.hh"

#include "TargetDialog_pf.hh"
#include "fwbuilder/Resources.hh"

using namespace libfwbuilder;

DialogPlugin* create_dialog_pf(FWObject *o)
{
    return new TargetDialog_pf(o);
}


TargetDialog_pf::TargetDialog_pf(FWObject *obj) 
{ 
    object=obj;

    fwoptions=(Firewall::cast(object))->getOptionsObject();
    assert(fwoptions!=NULL);


    label556->set_line_wrap(true);

    ((Gtk::Label*)(pf_do_scrub->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(pf_do_scrub->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

    ((Gtk::Label*)(pf_modulate_state->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(pf_modulate_state->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

    ((Gtk::Label*)(pf_configure_interfaces->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(pf_configure_interfaces->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

    ((Gtk::Label*)(pf_manage_virtual_addr->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(pf_manage_virtual_addr->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

    ((Gtk::Label*)(pf_debug->get_child()))->set_alignment(0.0,0.5);

    label570->set_line_wrap(true);

    ((Gtk::Label*)(pf_in_out_code->get_child()))->set_alignment(0.0,0.5);
    ((Gtk::Label*)(pf_pass_all_out->get_child()))->set_alignment(0.0,0.5);

    options.push_back( DialogOption( pf_in_out_code         , "in_out_code"             ));
    options.push_back( DialogOption( pf_pass_all_out        , "pass_all_out"            ));
    
    options.push_back( DialogOption( pf_check_shadowing     , "check_shading"           ));
    options.push_back( DialogOption( pf_ignore_empty_groups , "ignore_empty_groups"     ));
    options.push_back( DialogOption( pf_use_tables          , "use_tables"              ));
    
    options.push_back( DialogOption( pf_modulate_state      , "modulate_state"          ));

    options.push_back( DialogOption( pf_log_prefix          , "log_prefix"              ));
    
    options.push_back( DialogOption( pf_debug               , "debug"                   ));
    options.push_back( DialogOption( pf_configure_interfaces, "configure_interfaces"     ));
    options.push_back( DialogOption( pf_manage_virtual_addr , "manage_virtual_addr"     ));
    options.push_back( DialogOption( pf_fw_dir              , "firewall_dir"            ));
    
    options.push_back( DialogOption( pf_do_scrub            , "pf_do_scrub"             ));
    options.push_back( DialogOption( pf_scrub_no_df         , "pf_scrub_no_df"          ));
    options.push_back( DialogOption( pf_scrub_random_id     , "pf_scrub_random_id"      ));
    options.push_back( DialogOption( pf_scrub_fragm_crop    , "pf_scrub_fragm_crop"     ));
    options.push_back( DialogOption( pf_scrub_fragm_drop_ovl, "pf_scrub_fragm_drop_ovl" ));
    options.push_back( DialogOption( pf_scrub_use_minttl    , "pf_scrub_use_minttl"     ));
    options.push_back( DialogOption( pf_scrub_minttl        , "pf_scrub_minttl"         ));
    options.push_back( DialogOption( pf_scrub_use_maxmss    , "pf_scrub_use_maxmss"     ));
    options.push_back( DialogOption( pf_scrub_maxmss        , "pf_scrub_maxmss"         ));

    options.push_back( DialogOption( pf_limit_frags       , "pf_limit_frags"       ));
    options.push_back( DialogOption( pf_limit_states      , "pf_limit_states"      ));
    options.push_back( DialogOption( pf_timeout_interval  , "pf_timeout_interval"  ));
    options.push_back( DialogOption( pf_timeout_frag      , "pf_timeout_frag"      ));


    map<string,string>      optimizations;

    optimizations[""            ]="             ";
    optimizations["normal"      ]="normal       ";
    optimizations["high-latency"]="high latency ";
    optimizations["aggressive"  ]="aggressive   ";
    optimizations["conservative"]="conservative ";

    pf_optimization->set_menu(optimizations);
    pf_optimization->changed.connect(SigC::slot(this,&TargetDialog_pf::on_changed));
    pf_optimization->show_all();

    options.push_back( DialogOption( pf_optimization     , "pf_optimization"      ));
}

void TargetDialog_pf::on_changed()
{   
    DialogPlugin::data_changed_flag(true);
}

void TargetDialog_pf::on_pf_scrub_use_minttl_toggled()
{
    pf_scrub_minttl->set_sensitive( pf_scrub_use_minttl->get_active() );
}

void TargetDialog_pf::on_pf_scrub_use_maxmss_toggled()
{
    pf_scrub_maxmss->set_sensitive( pf_scrub_use_maxmss->get_active() );
}

void TargetDialog_pf::readDefaults()
{
    pf_fw_dir->set_text(
        Resources::platform_res["pf"]->getResourceStr(
            "/FWBuilderResources/Target/options/firewall_dir"));
}

void TargetDialog_pf::wrk2dlg()
{
    map<string,string>        fw_versions_menu;

    fw_versions_menu.clear();

    fw_versions_menu[DialogPlugin::magic_empty_option] = "";
    fw_versions_menu["obsd_lt_3.2"] = "OpenBSD prior to 3.2";
    fw_versions_menu["obsd_3.2"]    = "OpenBSD 3.2 and later";

    fw_version->set_menu(fw_versions_menu);
    fw_version->changed.connect(SigC::slot(this,&TargetDialog_pf::on_changed));
    fw_version->show_all();

    loadOptionMenu (object,fw_version,"version");

    loadPageOptions(fwoptions,  options);

    on_pf_scrub_use_minttl_toggled();
    on_pf_scrub_use_maxmss_toggled();
}

bool TargetDialog_pf::dlg2wrk()
{
    saveOptionMenu(object,fw_version,"version");

    savePageOptions(fwoptions,  options );
    return true;
}
