/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PIXAdvancedNetDialog.cc,v 1.2 2003/01/19 19:54:38 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "PIXAdvancedNetDialog.hh"

#include <gtk--.h>

using namespace libfwbuilder;

PIXAdvancedNetDialog::PIXAdvancedNetDialog(Firewall *_fo)
{ 
    fwobj=_fo;

    snmp_menu["1" ]="Poll"  ;
    snmp_menu["2" ]="Traps"  ;
    snmp_menu["3" ]="Poll and Traps"  ;

		
    snmp_poll_traps_1->set_menu(snmp_menu);
    snmp_poll_traps_1->show_all();

    snmp_poll_traps_2->set_menu(snmp_menu);
    snmp_poll_traps_2->show_all();


    ((Gtk::Label*)(tcpmss->get_child()))->set_alignment(0.0,1.0);

    ok_button->grab_focus();
}

void PIXAdvancedNetDialog::wrk2dlg()
{
    FWOptions *options=fwobj->getOptionsObject();
    assert(options!=NULL);

    ntp1->set_text( options->getStr("pix_ntp1") );
    ntp1_pref->set_active( options->getBool("pix_ntp1_pref") );
    ntp2->set_text( options->getStr("pix_ntp2") );
    ntp2_pref->set_active( options->getBool("pix_ntp2_pref") );
    ntp3->set_text( options->getStr("pix_ntp3") );
    ntp3_pref->set_active( options->getBool("pix_ntp3_pref") );

    set_communities->set_active( options->getBool("pix_set_communities_from_object_data") );
    set_sysinfo->set_active(     options->getBool("pix_set_sysinfo_from_object_data" ) );   
    enable_traps->set_active(    options->getBool("pix_enable_snmp_traps") );               

    snmp_server1->set_text( options->getStr("pix_snmp_server1") );
    snmp_server2->set_text( options->getStr("pix_snmp_server2") );

    snmp_poll_traps_1->set_active_item_by_value( options->getStr("pix_snmp_poll_traps_1") );
    snmp_poll_traps_2->set_active_item_by_value( options->getStr("pix_snmp_poll_traps_2") );

    tcpmss->set_active(              options->getBool("pix_tcpmss")      );
    tcpmss_value->set_value(         options->getInt("pix_tcpmss_value") );

    disable_snmp_agent->set_active( options->getBool("pix_disable_snmp_agent") );
}

void PIXAdvancedNetDialog::dlg2wrk()
{
    FWOptions *options=fwobj->getOptionsObject();
    assert(options!=NULL);

    options->setStr("pix_ntp1", ntp1->get_text( ) );
    options->setBool("pix_ntp1_pref", ntp1_pref->get_active() );
    options->setStr("pix_ntp2", ntp2->get_text( ) );
    options->setBool("pix_ntp2_pref", ntp2_pref->get_active() );
    options->setStr("pix_ntp3", ntp3->get_text( ) );
    options->setBool("pix_ntp3_pref", ntp3_pref->get_active() );

    options->setBool("pix_set_communities_from_object_data",set_communities->get_active() );
    options->setBool("pix_set_sysinfo_from_object_data"    ,set_sysinfo->get_active()     );
    options->setBool("pix_enable_snmp_traps"               ,enable_traps->get_active()    );

    options->setStr("pix_snmp_server1",snmp_server1->get_text());
    options->setStr("pix_snmp_server2",snmp_server2->get_text());

    options->setStr("pix_snmp_poll_traps_1", snmp_poll_traps_1->get_value() );
    options->setStr("pix_snmp_poll_traps_2", snmp_poll_traps_2->get_value() );

    options->setBool("pix_tcpmss"      , tcpmss->get_active());
    options->setInt( "pix_tcpmss_value", tcpmss_value->get_value_as_int());

    options->setBool("pix_disable_snmp_agent", disable_snmp_agent->get_active() );
}

bool PIXAdvancedNetDialog::run()
{
    ok=false;

// Load data
    wrk2dlg();

    show();
    Gtk::Main::grab_add(*this);
    Gtk::Main::run();
    Gtk::Main::grab_remove(*this);
    hide();

    if (ok) dlg2wrk();

    return ok;
}

void PIXAdvancedNetDialog::on_disable_snmp_agent_toggled()
{   
    bool dis = ! disable_snmp_agent->get_active();

    set_communities->set_sensitive(dis);
    set_sysinfo->set_sensitive(dis);
    enable_traps->set_sensitive(dis);

    snmp_server1->set_sensitive(dis);
    snmp_server2->set_sensitive(dis);

    snmp_poll_traps_1->set_sensitive(dis);
    snmp_poll_traps_2->set_sensitive(dis);
}

void PIXAdvancedNetDialog::on_ok_clicked()
{   
    ok=true;
    Gtk::Main::quit();
}

void PIXAdvancedNetDialog::on_cancel_clicked()
{   
    ok=false;
    Gtk::Main::quit();
}

void PIXAdvancedNetDialog::on_pix_new_arp_clicked()
{   
}

void PIXAdvancedNetDialog::on_pix_edit_arp_clicked()
{   
}

void PIXAdvancedNetDialog::on_pix_del_arp_clicked()
{   
}
