/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TargetDialog_pix.cc,v 1.4 2003/09/29 07:26:57 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "fwbuilder/XMLTools.hh"
#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Firewall.hh"
#include "fwbuilder/Resources.hh"

#include "TargetDialog_pix.hh"
#include "PIXAdvancedFWDialog.hh"
#include "ScriptEditor.hh"

using namespace libfwbuilder;

DialogPlugin* create_dialog_pix(FWObject *o)
{
    return new TargetDialog_pix(o);
}

TargetDialog_pix::TargetDialog_pix(FWObject *obj)
{
    object=obj;

    fwoptions=(Firewall::cast(object))->getOptionsObject();
    assert(fwoptions!=NULL);

    ((Gtk::Label*)(pix_emulate_out_acl->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(pix_include_comments->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(pix_use_acl_remarks->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(pix_regroup_commands->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(pix_check_shadowing->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(pix_check_duplicate_nat->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(pix_check_overlapping_global_pools->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(pix_check_overlapping_statics->get_child()))->set_alignment(0.0,1.0);
    ((Gtk::Label*)(pix_check_overlapping_global_statics->get_child()))->set_alignment(0.0,1.0);

    ((Gtk::Label*)(pix_replace_natted_objects->get_child()))->set_justify(GTK_JUSTIFY_LEFT);

//    pix_support_version->set_text("PIX support modules and compiler v"+  
//                       Resources::platform_res["pix"]->getVersion() );


    options.push_back( DialogOption( pix_assume_fw_part_of_any  , 
                                     "pix_assume_fw_part_of_any") );

    options.push_back( DialogOption( pix_replace_natted_objects  , 
                                     "pix_replace_natted_objects") );

    options.push_back( DialogOption( pix_emulate_out_acl  , 
                                     "pix_emulate_out_acl") );

    options.push_back( DialogOption( pix_include_comments , 
                                     "pix_include_comments") );

    options.push_back( DialogOption( pix_use_acl_remarks , 
                                     "pix_use_acl_remarks") );

    options.push_back( DialogOption( pix_regroup_commands , 
                                     "pix_regroup_commands") );

    options.push_back( DialogOption( pix_add_clear_statements , 
                                     "pix_add_clear_statements") );

    options.push_back( DialogOption( pix_optimize_default_nat , 
                                     "pix_optimize_default_nat") );

    options.push_back( DialogOption( pix_prolog_script    , 
                                     "pix_prolog_script" ) );

    options.push_back( DialogOption( pix_epilog_script    , 
                                     "pix_epilog_script" ) );

    options.push_back( DialogOption( pix_check_shadowing    , 
                                     "check_shading" ) );

    options.push_back( DialogOption( pix_ignore_empty_groups , 
                                     "ignore_empty_groups" ));

    options.push_back( DialogOption( pix_check_duplicate_nat    , 
                                     "pix_check_duplicate_nat" ) );

    options.push_back( DialogOption( pix_check_overlapping_global_pools , 
                                     "pix_check_overlapping_global_pools") );

    options.push_back( DialogOption( pix_check_overlapping_statics , 
                                     "pix_check_overlapping_statics") );

    options.push_back( DialogOption( pix_check_overlapping_global_statics , 
                                     "pix_check_overlapping_global_statics") );
}

void TargetDialog_pix::on_changed()
{   
    DialogPlugin::data_changed_flag(true);
}

void TargetDialog_pix::on_pix_advanced_fw_clicked()
{   
    PIXAdvancedFWDialog *pafd=new PIXAdvancedFWDialog(Firewall::cast(object));
    pafd->run();
    delete pafd;
    on_changed();
}


void TargetDialog_pix::readDefaults()
{
    vector<string>   fw_versions;

    getVersions( fw_versions );

    string v= fw_versions.back();
    object->setStr("version",v);
    v= "version_"+fw_versions.back();

    loadOptionMenu (object,fw_version,"version");
    
    list<string> timeouts;

    timeouts.push_back("xlate"    );
    timeouts.push_back("conn"     );
    timeouts.push_back("udp"      );
    timeouts.push_back("rpc"      );
    timeouts.push_back("h323"     );
    timeouts.push_back("sip"      );
    timeouts.push_back("sip_media");
    timeouts.push_back("uauth"    );

    FWOptions *options=Firewall::cast(object)->getOptionsObject();
    assert(options!=NULL);

    for (list<string>::iterator i=timeouts.begin(); i!=timeouts.end(); ++i)
    {
        string option=*i;
        
        Resources::platform_res["pix"]->
            setDefaultOption(options,"/FWBuilderResources/Target/options/"+v+"/timeouts/"+option+"_hh");
        Resources::platform_res["pix"]->
            setDefaultOption(options,"/FWBuilderResources/Target/options/"+v+"/timeouts/"+option+"_mm");
        Resources::platform_res["pix"]->
            setDefaultOption(options,"/FWBuilderResources/Target/options/"+v+"/timeouts/"+option+"_ss");
    }
    

    Resources::platform_res["pix"]->
        setDefaultOption(options, "/FWBuilderResources/Target/options/"+v+"/timeouts/uauth_abs");
    Resources::platform_res["pix"]->
        setDefaultOption(options, "/FWBuilderResources/Target/options/"+v+"/timeouts/uauth_inact");
        
    Resources::platform_res["pix"]->
        setDefaultOption(options, "/FWBuilderResources/Target/options/"+v+"/timeouts/telnet_timeout");
    Resources::platform_res["pix"]->
        setDefaultOption(options, "/FWBuilderResources/Target/options/"+v+"/timeouts/ssh_timeout");
    

    pix_emulate_out_acl->set_active(
        Resources::platform_res["pix"]->getResourceBool(
            "/FWBuilderResources/Target/options/"+v+"/pix_emulate_out_acl"));

    pix_include_comments->set_active(
        Resources::platform_res["pix"]->getResourceBool(
            "/FWBuilderResources/Target/options/"+v+"/pix_include_comments"));

    pix_use_acl_remarks->set_active(
        Resources::platform_res["pix"]->getResourceBool(
            "/FWBuilderResources/Target/options/"+v+"/pix_use_acl_remarks"));

    pix_add_clear_statements->set_active(
        Resources::platform_res["pix"]->getResourceBool(
            "/FWBuilderResources/Target/options/"+v+"/pix_add_clear_statements"));

    pix_assume_fw_part_of_any->set_active(
        Resources::platform_res["pix"]->getResourceBool(
            "/FWBuilderResources/Target/options/"+v+"/pix_assume_fw_part_of_any"));

}

void TargetDialog_pix::getVersions(vector<string> &versions)
{
    versions.clear();

    string lst=Resources::platform_res["pix"]->getResourceStr(
            "/FWBuilderResources/Target/versions");

    string::size_type i,j, k;
    string s;
    i=0;
    while ( (j=lst.find(",",i))!=string::npos )
    {
        s=lst.substr(i,j-i);
        i=j+1;
        versions.push_back(s);
    }
    s=lst.substr(i);
    versions.push_back(s);
}

void TargetDialog_pix::wrk2dlg()
{
    vector<string>        fw_versions_menu;

    getVersions( fw_versions_menu );

    fw_version->set_menu(fw_versions_menu);
    fw_version->changed.connect(SigC::slot(this,&TargetDialog_pix::on_changed));
    fw_version->show_all();

    if (object->getStr("version").empty())
        object->setStr("version","6.1");

    loadOptionMenu (object,fw_version,"version");

    loadPageOptions(fwoptions,  options);
}

bool TargetDialog_pix::dlg2wrk()
{
    saveOptionMenu(object,fw_version,"version");

    savePageOptions(fwoptions,  options );
    return true;
}

void TargetDialog_pix::on_edit_prolog_clicked()
{   
    ScriptEditor *se=new ScriptEditor( pix_prolog_script->get_chars(0,pix_prolog_script->get_length()));
    if ( se->run() )
    {
        pix_prolog_script->set_point(0);
        pix_prolog_script->forward_delete( pix_prolog_script->get_length() );
        pix_prolog_script->insert( XMLTools::cleanForNVTASCII( se->getScript() ) );
        on_changed();
    }
    delete se;
}

void TargetDialog_pix::on_edit_epilog_clicked()
{   
    ScriptEditor *se=new ScriptEditor( pix_epilog_script->get_chars(0,pix_epilog_script->get_length()));
    if ( se->run() )
    {
        pix_epilog_script->set_point(0);
        pix_epilog_script->forward_delete( pix_epilog_script->get_length() );
        pix_epilog_script->insert( XMLTools::cleanForNVTASCII( se->getScript() ) );
        on_changed();
    }
    delete se;
}

