/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: fwbaskpwd.cc,v 1.4 2003/10/10 06:37:03 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif
/* internationalisation by f. manens */
#ifdef ENABLE_NLS
#include "gettext.h"
#define _(String) gettext (String)
#define gettext_noop(String) String
#define N_(String) gettext_noop (String)
#endif

#include <unistd.h>

#include <gtk--/main.h>
#include <gtk/gtkrc.h>

#include "AskPasswordDialog.hh"
#include "glademm_support.hh"

#include <iostream>

#ifdef __MINGW32__
  #include <getopt.h>
  #include <winsock2.h>
#else
  #ifdef HAVE_GETOPT_H
    #include <getopt.h>
  #else
    #include <stdlib.h>
  #endif
#endif

/**
 *   This handler gets called whenever gtk event loop is stopped via 
 *   Gtk::Main::quit()
 */

gint quit_handler()
{
    if (gtk_main_level()==1) {
// this is the  end of program


    }
    return true;
}

void usage()
{
    cerr << _("Usage: fwbaskpwd [-m 1|2]") << endl;
}



int main(int argc, char * const *argv)
{   

#ifdef ENABLE_NLS
    setlocale (LC_ALL, "");

    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain (PACKAGE);
#else
#  ifdef HAVE_SETLOCALE
    setlocale (LC_ALL, "");
#  endif
#endif

    Gtk::Main m(&argc, (char***)(&argv) , true );

    int         mode=1;
    std::string username;
    int c;
    while ((c = getopt (argc , argv , "m:u:")) != EOF )
	switch (c) {
	case 'm':
	    mode=atoi(optarg);
	    break;
        case 'u':
            username=optarg;
            break;
	}
    
    Gtk::Main::quit.connect( SigC::slot( &quit_handler )  ) ;

    try
    {
        AskPasswordDialog *askpwd;
        switch (mode)
        {
        case 1:
            askpwd=new AskPasswordDialog(LOGIN_AND_PWD,"");
            break;
        case 2:
            askpwd=new AskPasswordDialog(ONLY_PWD,username);
            break;
        case 3:
            askpwd=new AskPasswordDialog(PWD_AND_ENABLE,username);
            break;
        }
        if ( askpwd->run() )
        {
            switch (mode)
            {
            case 1:
            case 3:
                cout << askpwd->getLine1() << endl << askpwd->getLine2() << endl;
                break;
            case 2:
                cout << askpwd->getLine1() << endl;
                break;
            }
        }
    } catch (std::string s) {
        cerr << s;
        return 1;
    } catch (std::exception ex) {
        cerr << ex.what();
        return 1;
    } catch (...) {
        cerr << _("Unsupported exception");
        return 1;
    }

    return 0;
}

