/* 

                          Firewall Builder

                 Copyright (C) 2006 NetCitadel, LLC

  Author:  Illiya Yalovoy <yalovoy@gmail.com>

  $Id: instOptionsDialog.cpp,v 1.3 2007/04/25 05:00:36 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "utils.h"
#include "platforms.h"
#include "definitions.h"

#include "instOptionsDialog.h"

#include <qstring.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qspinbox.h>

#include <stdlib.h>

using namespace std;
using namespace libfwbuilder;

    
instOptionsDialog::instOptionsDialog(QWidget *parent) : instOptionsDialog_q(parent)
{
    delta_y = 0;
    setSizeGripEnabled(false);
    resize( 600, 600 );

    updateRollback();
}

void instOptionsDialog::applyChanges()
{
    hide();
}

void instOptionsDialog::discardChanges()
{
    hide();
}

void instOptionsDialog::updateRollback()
{
    bool f = testRun->isChecked();
    rollback->setEnabled(f);
    rollbackTime->setEnabled(f);
    rollbackTimeUnit->setEnabled(f);
}

QString instOptionsDialog::getUName() { return uname->text(); }
QString instOptionsDialog::getPWD()   { return pwd->text();   }
QString instOptionsDialog::getEPWD()  { return epwd->text();  }

void instOptionsDialog::hidePIXOptions()
{
    QLayout *l = layout();
    int m = l->spacing();

    delta_y += incr->height() + m;                  incr->hide();
    delta_y += test->height() + m;                  test->hide();
    //delta_y += saveDiff->height() + m;              saveDiff->hide();
    delta_y += saveStandby->height() + m;           saveStandby->hide();
    delta_y += backupConfigFile->height() + m;      backupConfigFile->hide();
    delta_y += backupConfigFileLbl->height() + m;   backupConfigFileLbl->hide();
    delta_y += epwd->height() + m;                  epwd->hide();
    delta_y += epwdLbl->height() + m;               epwdLbl->hide();

    PIXgroupBox->hide();
}

void instOptionsDialog::hideOption(QWidget *w)
{
    delta_y += w->height();
    w->hide();
}

void instOptionsDialog::closeEvent(QCloseEvent *e)
{
    if (fwbdebug)
        qDebug("instOptionsDialog::closeEvent  got close event: %p",e);
    hide();
}

QSize instOptionsDialog::sizeHint() const
{
    QSize sh = QDialog::sizeHint();
    sh.setHeight( sh.height() - ((delta_y)?(delta_y+20):0) );
    if (fwbdebug)
    {
        qDebug(QString("instOptionsDialog::sizeHint:  w=%1 h=%2").arg(sh.width()).arg(sh.height()));
        qDebug(QString("delta_y=%1").arg(delta_y));
    }
    return sh;
}

QSize instOptionsDialog::minimumSizeHint() const
{
    QSize sh = QDialog::minimumSizeHint();
    sh.setHeight( sh.height() - ((delta_y)?(delta_y+20):0) );
    if (fwbdebug)
    {
        qDebug(QString("instOptionsDialog::minimumSizeHint:  w=%1 h=%2").arg(sh.width()).arg(sh.height()));
        qDebug(QString("delta_y=%1").arg(delta_y));
    }
    return sh;
}

