/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: FWObjectDrag.h,v 1.5 2004/07/06 05:11:58 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef  __FWOBJECTDRAG_H_
#define  __FWOBJECTDRAG_H_

#include <qdragobject.h>
#include <map>
#include <list>

namespace libfwbuilder {
    class FWObject;
};

/*****************************************************************************
 *
 * Class FWObjectDrag
 *
 *****************************************************************************/

class FWObjectDrag : public QStoredDrag {

    Q_OBJECT

private:

    std::list<libfwbuilder::FWObject*> objlist;

    static QString FWB_MIME_TYPE;

    
public:

    FWObjectDrag(std::list<libfwbuilder::FWObject*> ol,
                 QWidget *dragSource = 0, const char* name = 0);
    ~FWObjectDrag();

    virtual bool drag(DragMode mode);
    
    QByteArray encodedData( const char* mime ) const;
    static bool canDecode( QMimeSource* e );
    static bool decode( QDropEvent *ev, std::list<libfwbuilder::FWObject*> &ol);
};

#endif

