/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: debugDialog.cpp,v 1.11 2006/10/22 05:24:28 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"

#include "debugDialog.h"
#include "RCS.h"
#include "FWWindow.h"

#include <qtextbrowser.h>
#include <qtextcodec.h>
#include <qglobal.h>
#include <qpixmapcache.h>

#include "fwbuilder/Constants.h"
#include "fwbuilder/FWObjectDatabase.h"

#include <iostream>

using namespace std;

    
debugDialog::debugDialog(QWidget *parent) : debugDialog_q(parent) 
{

/*
 * some variables used for remote debugging (so I can ask the user to
 * send me a screenshot of the "about" dialog and get the idea about
 * their environment etc.)
 */
    debugText->append( QString("Path to executable: %1").arg(argv0.c_str()) );
    debugText->append( QString("Path to resources: %1").arg(respath.c_str()) );
    debugText->append( QString("Path to locale: %1").arg(localepath.c_str()) );
    debugText->append( QString("Path to lib resources: %1").arg(librespath.c_str()) );
    debugText->append( QString("appRootDir: %1").arg(appRootDir.c_str()) );
    debugText->append( "\n" );
    debugText->append( QString("sysfname: %1").arg(sysfname.c_str()) );
    debugText->append( QString("tempfname: %1").arg(tempfname.c_str()) );
    debugText->append( "\n" );
    debugText->append( QString("Path to rcs: %1").arg(RCS_FILE_NAME) );
    debugText->append( QString("Path to rcsdiff: %1").arg(RCSDIFF_FILE_NAME) );
    debugText->append( QString("Path to rlog: %1").arg(RLOG_FILE_NAME) );
    debugText->append( QString("Path to ci: %1").arg(CI_FILE_NAME) );
    debugText->append( QString("Path to co: %1").arg(CO_FILE_NAME) );
    debugText->append( "\n" );

    debugText->append( "RCS timezone setting:" );
    debugText->append( RCS::getRCSEnvFix()->getTZOffset() );
    debugText->append( "\n" );
    debugText->append( "RCS environment:" );
    debugText->append( RCS::getEnv()->join("\n").ascii() );
    debugText->append( "\n" );

    debugText->append( QString("Current locale: %1").arg(QTextCodec::locale()) );
    debugText->append( "\n" );
    debugText->append( QString("Versions:") );
    debugText->append( QString("  Firewall Builder %1").arg(VERSION) );
    debugText->append( QString("  Release %1  Build %2").arg(RELEASE_NUM).arg(BUILD_NUM) );
    debugText->append( QString("  Using libfwbuilder %1")
                 .arg( libfwbuilder::Constants::getLibraryVersion().c_str() ) );
    debugText->append( QString("  Built with QT %1").arg(QT_VERSION_STR) );
    debugText->append( QString("  Using QT %1").arg( qVersion() ) );
    debugText->append( QString("  Built with libxml2 %1").arg(LIBXML_DOTTED_VERSION) );
#if !defined(Q_OS_MACX)
    debugText->append( QString("  Using libxml2 %1").arg(xmlParserVersion) );
#endif
    debugText->append( "\n" );

    debugText->append( QString("FWObjectDatabase index statistics:") );
    
    int s,h,m;
    mw->db()->getIndexStats(s,h,m);
    debugText->append( QString("  index size: %1 records").arg(s) );
    debugText->append( QString("  hits: %1").arg(h) );
    debugText->append( QString("  misses: %1").arg(m) );
    debugText->append( "\n" );

    debugText->append( QString("QPixmapCache limit: %1 kb").arg(QPixmapCache::cacheLimit()));
}
