/* 

                          Firewall Builder

                 Copyright (C) 2011 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "PreImport.h"

#include <QRegExp>


void PreImport::scan()
{
    QList<QRegExp> pix_re;
    pix_re << QRegExp("^ASA Version")
           << QRegExp("^PIX Version")
           << QRegExp("^FWSM Version")
           << QRegExp("^nat \\(\\S+,\\S+\\)")
           << QRegExp("^static \\(\\S+,\\S+\\)")
           << QRegExp("^global \\(")
           << QRegExp("^nameif \\S+")
           << QRegExp("^fixup \\S+");

    QList<QRegExp> fwsm_re;
    fwsm_re << QRegExp("^FWSM Version");

    QList<QRegExp> ios_re;
    ios_re << QRegExp("IOS Version")
           << QRegExp("^[vV]ersion 1[012]\\..*");

    QList<QRegExp> iptables_re;
    iptables_re << QRegExp("# Generated by iptables-save")
                << QRegExp("^:INPUT ")
                << QRegExp("^:OUTPUT ")
                << QRegExp("^:FORWARD ")
                << QRegExp("^-A INPUT ")
                << QRegExp("^-A OUTPUT ")
                << QRegExp("^-A FORWARD ");
            
    QList<QRegExp> iptables_with_counters_re;
    iptables_with_counters_re << QRegExp("^\\[\\d+:\\d+\\] -A INPUT ")
                              << QRegExp("^\\[\\d+:\\d+\\] -A OUTPUT ")
                              << QRegExp("^\\[\\d+:\\d+\\] -A FORWARD ");

    QList<QRegExp> pf_conf_re;
    pf_conf_re << QRegExp("^scrub\\s+\\S+")
               << QRegExp("^set\\s+timeout\\s+\\S+")
               << QRegExp("^pass\\s+")
               << QRegExp("^block\\s+")
               << QRegExp("^nat\\s+(?!\\()")
               << QRegExp("^rdr\\s+(?!\\()")
               << QRegExp("^table\\s+<\\S+>\\s+");


    foreach (QString line, *buffer)
    {
        if (platform == UNKNOWN)
        {
            foreach (QRegExp re, pix_re)
            {
                if (re.indexIn(line) > -1)
                {
                    platform = PIX;
                    break;
                }
            }

            foreach (QRegExp re, fwsm_re)
            {
                if (re.indexIn(line) > -1)
                {
                    platform = FWSM;
                    break;
                }
            }

            foreach (QRegExp re, ios_re)
            {
                if (re.indexIn(line) > -1)
                {
                    platform = IOSACL;
                    break;
                }
            }

            foreach (QRegExp re, iptables_re)
            {
                if (re.indexIn(line) > -1)
                {
                    platform = IPTABLES;
                    break;
                }
            }

            foreach (QRegExp re, pf_conf_re)
            {
                if (re.indexIn(line) > -1)
                {
                    platform = PF;
                    break;
                }
            }
        }

        if (platform == IPTABLES)
        {
            foreach (QRegExp re, iptables_with_counters_re)
            {
                if (re.indexIn(line) > -1)
                {
                    platform = IPTABLES_WITH_COUNTERS;
                    break;
                }
            }
        }
    }
}

QString PreImport::getPlatformAsString()
{
    QString platform_string;

    switch (platform)
    {
    case PreImport::UNKNOWN:
        platform_string = "";
        break;

    case PreImport::PIX:
        platform_string = "pix";
        break;

    case PreImport::FWSM:
        platform_string = "fwsm";
        break;

    case PreImport::IOSACL:
        platform_string = "iosacl";
        break;

    case PreImport::IPTABLES:
    case PreImport::IPTABLES_WITH_COUNTERS:
        platform_string = "iptables";
        break;

    case PreImport::PF:
        platform_string = "pf";
        break;
    }

    return platform_string;
}

