//====================================================================
//                
// Copyright (C) 2006,  Goedson Teixeira Paixao
//                
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
//                
// Filename:      TextFormatter.hh
// Author:        Goedson Teixeira Paixao <goedson@debian.org>
// Description:   
//                
// Created at:    Sat May  6 15:55:21 2006
// Modified at:   Sun May  7 12:14:47 2006
// Modified by:   Goedson Teixeira Paixao <goedson@debian.org>
//====================================================================

#ifndef __GABBER_INCL_TEXTFORMATTER_HH__
#define __GABBER_INCL_TEXTFORMATTER_HH__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include "fwd.h"
#include "TextFormatter.hh"

#include <sigc++/object.h>
#include <gtkmm/textbuffer.h>
#include <map>


namespace Gabber
{
    class TextFormatter {
    public:
        TextFormatter(Glib::RefPtr<Gtk::TextBuffer> buffer);
        ~TextFormatter();
        void format_text(const Glib::ustring& body, bool seen = false);
        bool on_tag_uri_event(const Glib::RefPtr<Glib::Object>& o, GdkEvent* e, const Gtk::TextIter& i);

    private:
        std::map<Glib::ustring,Glib::ustring> _emoticons;
        bool is_uri(const Glib::ustring& text);
        Glib::ustring get_emoticon_name(const Glib::ustring& text);
        Glib::RefPtr<Gtk::TextBuffer> _buffer;
        Glib::RefPtr<Gtk::TextBuffer::Tag> _uritag;
        Glib::RefPtr<Gtk::TextBuffer::Tag> _clickedtag;
    };
}

#endif
