/**********************************************************************************************************
Copyright (c) 2002-2009 Abdul-Rahman Allouche. All rights reserved

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
documentation files (the Gabedit), to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all copies or substantial portions
  of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
************************************************************************************************************/

#ifndef __GABEDIT_UTILS_H__
#define __GABEDIT_UTILS_H__

#define NHOSTMAX  	5
#define LOGFILE  	0
#define OUTFILE  	1
#define MOLDENFILE  	2
#define ALLFILES  	3
typedef struct _Point
{
 gdouble C[3];
}Point;

typedef struct _DataTree
{
 gchar *projectname;
 gchar *datafile;
 gchar *localdir;

 gchar *remotehost;
 gchar *remoteuser;
 gchar *remotepass;
 gchar *remotedir;
 GabEditNetWork netWorkProtocol; 

 gint itype;
 gchar* command;
 GtkTreeIter* noeud;
}DataTree;

void timing(double* cpu,double *sys);
#ifdef G_OS_WIN32
gboolean winsockCheck(FILE* );
#endif /* G_OS_WIN32 */
void free_gaussian_commands();
void free_molpro_commands();
void free_mpqc_commands();
gchar* get_time_str();
gboolean this_is_a_backspace(gchar *st);
void changeDInE(gchar *st);
FILE* FOpen(const gchar *fileutf8, const gchar* type);
void  set_file_open(gchar* remotehost,gchar* remoteuser,gchar* remotedir, GabEditNetWork netWorkProtocol);
gboolean  this_is_an_object(GtkObject *obj);
G_CONST_RETURN gchar *get_local_user();
void Waiting(gdouble tsecond);
void Debug(char *fmt,...);
void add_host(const gchar *hostname, const gchar* username, const gchar* password, const gchar* dir);
gchar* get_line_chars(gchar c,gint n);
gchar* cat_file(gchar* namefile,gboolean tabulation);
gchar *run_command(gchar *command);
void run_local_command(gchar *outfile,gchar *errfile,gchar* command,gboolean under);
const gchar *gabedit_directory(void);
void DeleteLastChar(gchar *);
gchar *get_suffix_name_file(const gchar*);
gchar *get_dir_file_name(G_CONST_RETURN gchar* dirname, G_CONST_RETURN gchar* filename);
gchar *get_name_dir(const gchar* );
gchar *get_name_file(const gchar* );
Point get_produit_vectoriel(Point V1,Point V2);
gchar *get_distance_points(Point P1,Point P2,gboolean f3);
gdouble get_module(Point V);
gdouble get_scalaire(Point V1,Point V2);
gchar *get_angle_vectors(Point V1,Point V2);
void create_hosts_file();
void create_ressource_file();
void read_ressource_file();
gchar *ang_to_bohr(gchar *);
gchar *bohr_to_ang(gchar *);
guint get_number_electrons(guint);
gdouble get_value_variableZmat(gchar *);
gdouble get_value_variableXYZ(gchar *);
guint get_num_variableXYZ(gchar *);
guint get_num_variableZmat(gchar *);
gboolean geometry_with_medium_layer();
gboolean geometry_with_lower_layer();
void uppercase(gchar *);
void lowercase(gchar *);
void initialise_batch_commands();
void initialise_name_file();
void reset_name_files();
void initialise_global_variables();
void run_molden (gchar *);
gboolean variable_name_valid(gchar *);
gboolean testa(char );
gboolean test(const gchar *);
gboolean testapointeE(char );
gboolean testpointeE(const gchar *);
void create_commands_file();
void create_network_file();
void create_fonts_file();
void set_tab_size (GtkWidget *view, gint tab_size);
void set_font (GtkWidget *view, gchar *fontname);
void set_font_style (GtkStyle* style,gchar *fontname);
GtkStyle *set_text_style(GtkWidget *text,gushort red,gushort green,gushort blue);
GtkStyle *set_base_style(GtkWidget *text,gushort red,gushort green,gushort blue);
GtkStyle *set_fg_style(GtkWidget *wid,gushort red,gushort green,gushort blue);
GtkStyle *set_bg_style(GtkWidget *wid,gushort red,gushort green,gushort blue);
gint numb_of_string_by_row(gchar *str);
gint numb_of_reals_by_row(gchar *str);
gchar** gab_split(gchar *str);
void get_dipole_from_gamess_output_file(FILE* fd);
void get_dipole_from_gaussian_output_file(FILE* fd);
void get_dipole_from_molpro_output_file(FILE* fd);
void get_dipole_from_dalton_output_file(FILE* fd);
void get_dipole_from_orca_output_file(FILE* fd);
void get_dipole_from_qchem_output_file(FILE* fd);
void get_dipole_from_mopac_output_file(FILE* fd);
void get_dipole_from_mopac_aux_file(FILE* fd);
void set_dipole(GtkWidget* fp,gpointer data);
void read_commands_file();
void read_network_file();
void set_path();
void read_hosts_file();
void read_fonts_file();
void delete_last_spaces(gchar* str);
void delete_first_spaces(gchar* str);
void delete_all_spaces(gchar* str);
void str_delete_n(gchar* str);
gchar* get_to_str(gchar* str,gchar* end);
gboolean isInteger(gchar *t);
gboolean isFloat(const gchar *t);
void get_symb_type_charge(gchar* str,gchar symb[], gchar type[], gchar charge[]);
gchar* get_font_label_name();
gint get_type_of_program(FILE* file);
void gabedit_string_get_pixel_size(GtkWidget* parent, PangoFontDescription *font_desc, G_CONST_RETURN gchar* t, int *width, int* height);
void gabedit_draw_string(GtkWidget* parent, GdkPixmap* pixmap, PangoFontDescription *font_desc, GdkGC* gc , gint x, gint y, G_CONST_RETURN gchar* t, gboolean centerX, gboolean centerY);
void gabedit_save_image(GtkWidget* widget, gchar *fileName, gchar* type);
G_CONST_RETURN gchar* get_open_babel_command();
gchar** get_one_block_from_aux_mopac_file(FILE* file, gchar* blockName,  gint* n);
gchar** free_one_string_table(gchar** table, gint n);
gboolean zmat_mopac_scan_output_file(gchar *FileName);
GabEditTypeFile get_type_output_file(gchar* fileName);
GabEditTypeFile get_type_input_file(gchar* fileName);
GabEditTypeFile get_type_file(gchar* filename);

#endif /* __GABEDIT_UTILS_H__ */

