/*
 * categories.h
 * Thomas Nemeth, le 22.02.2000 (from acclists.h 18.09.1999)
 *
 * HEADER
 * Gestion de la liste des donnes de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _CATEGORIES_H_
#define _CATEGORIES_H_

#include "structs.h"

/* ------++++++======*** CATGORIES * CATEGORIES ***======++++++----- */

/* Charge les dfinitions des catgories                              */
/* Load categories' definitions                                       */
void read_categories_from_file ();

/* crit les dfinitions des catgories dans un fichier               */
/* Write categories' definitions in a file                            */
void write_categories_to_file ();

/* Ajoute une catgorie  la liste                                    */
/* Add a category to the list                                         */
void add_category (CATEGORY *category);

/* Enlve une catgorie sans l'effacer                                */
/* Remove a category without deleting it                              */
void remove_category (CATEGORY *category);

/* Efface une categorie de la liste                                   */
/* Delete a category from the list                                    */
void del_category (CAT_ELT *element);

/* Rcupre une catgorie par son numro (premier == 0) dans la liste */
/* Get a category by its number (first == 0) in the list              */
CAT_ELT *get_category (int cat_num);

/* Rcupre le prochain numro  affecter  une catgorie             */
/* Get the next number to affect a category                           */
int get_category_next_num ();

/* Renvoie le nom de la catgorie associe au numro                  */
/* Return the name of the category associated with the number         */
char *category_name (int cat_num);

/* Renvoie le numro de la catgorie associe au nom                  */
/* Return the number of the category associated with the name         */
int category_number (char *cat_name);

/* Libre la mmoire utilise par la liste des catgories             */
/* Free the memory used by the categories list                        */
void free_categories ();

/* Oprations sur les catgories                                      */
/* Operations on categories                                           */
CATEGORY *category_new ();
CATEGORY *get_category_from_line (const char *line);
char *create_line_from_category (CATEGORY *cat);
CAT_ELT *cat_list_elt_new ();
void cat_set_name (CATEGORY *cat, const char *name);
void cat_set_num (CATEGORY *cat, int num);
void cat_set_type (CATEGORY *cat, int type);

#endif
