/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "show_info.h"
#include "reread_conf.h"
#include "functions.h"
#include "commented.h"

extern char global_hwaddr[1024];
extern char global_ipaddr[1024];
extern char global_hostname[1024];

extern char DHCPD_CONF_BUF[1024];
extern int MAX_CONF_LINE;



void delete_host(struct w *widgets)
{
    FILE *fp;
    long conf_size = 0;
    int found_host = 0;
    char *line, *new_conf;
    gchar *info;

    if( strlen(global_hostname)==0 || strlen(global_ipaddr)==0 || strlen(global_hwaddr)==0 )
    {
       info = g_strdup_printf(_("Delete host: missing values, host not deleted\n"));
       show_info(info);
       g_free(info);
       return;
    }

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
        printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    new_conf = allocate(conf_size+1);
    line     = allocate(conf_size+1);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( commented(line) || strlen(line) > MAX_CONF_LINE )
{
    strcat(new_conf, line);
	  continue;
}
	if( is_selected_host(global_hostname, line) )
	{
	    found_host = 1;
	
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		if( strstr(line, "}") && ! commented(line) )
		  break;
	    }
	}
	else
	  strcat(new_conf, line);
    }
    fclose(fp);

    if( found_host )
    {
	if((fp=fopen(DHCPD_CONF_BUF, "w+"))==NULL)
	{
    	    printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
    	    return;
	}
	else
          {
             fputs(new_conf, fp);
	     fclose(fp);
	  }
    }
    free(new_conf);
    free(line);
}
