/* GADMIN-SQUID - An easy to use GTK+ frontend for the Squid proxy server.
 * Copyright (C) 2006 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "show_info.h"
#include "allocate.h"
#include "chars_are_digits.h"
#include "populate_server_settings.h"
#include "commented.h"
#include "functions.h"
#include "get_option_pos.h"

extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];
extern int use_tls;



void populate_server_settings(struct w *widgets)
{
    /* Lists the server settings in the server tab */
    FILE *fp;
    int x=0, val=0;
    long i = 0, file_size = 0, opt_pos = 0;
    char *line, *new_buffer, *firstopt;
    gchar *info, *utf8 = NULL;

//    Clear all entries
//    for(x=0; x<14; x++)
//      gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[x]), "");

    if((fp=fopen(SQUID_CONF, "r"))==NULL)
    {
	/* We just show this popup here too many windows looks bad */
	info = g_strdup_printf("%s %s", _("Error: Cant open squid.conf here:\n"), SQUID_CONF);
        show_info(info);
        g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size);
    new_buffer = allocate(file_size);               

    /* Populate the server settings */
    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
	if( commented(line) )
	  continue;

	/* Only compare against the actual option */
	opt_pos = get_option_pos(line, 1);
	firstopt = allocate(opt_pos+1024);
	/* Remove any whitespace before the option */
	for(i=0; line[i]!='\0' && line[i]==' '; i++)
	{ }
	snprintf(firstopt, opt_pos-i, "%s", &line[i]);


/* First populate the entries */
	if( ! strcmp(firstopt, "visible_hostname") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);

	    for(x=0; new_buffer[x]!='\0'; x++)
	    if( new_buffer[x]==':' || new_buffer[x]=='\n' )
	    {
		new_buffer[x]='\0';
		break;
	    }
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[0]), utf8);
	}
   	if( ! strcmp(firstopt, "mail_from") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[1]), utf8);
	}
   	if( ! strcmp(firstopt, "client_netmask") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[2]), utf8);
	}
   	if( ! strcmp(firstopt, "dns_nameservers") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[3]), utf8);
	}
   	if( ! strcmp(firstopt, "snmp_incoming_address") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[4]), utf8);
	}
   	if( ! strcmp(firstopt, "snmp_outgoing_address") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[5]), utf8);
	}
   	if( ! strcmp(firstopt, "udp_incoming_address") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[6]), utf8);
	}
   	if( ! strcmp(firstopt, "udp_outgoing_address") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[7]), utf8);
	}
   	if( ! strcmp(firstopt, "icp_port") ) /* This can also contain chars, hence the entry */
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[8]), utf8);
	}
   	if( ! strcmp(firstopt, "cache_replacement_policy") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[9]), utf8);
	}
   	if( ! strcmp(firstopt, "memory_replacement_policy") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[10]), utf8);
	}
   	if( ! strcmp(firstopt, "cache_dir") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[11]), utf8);
	}
   	if( ! strcmp(firstopt, "hierarchy_stoplist") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[12]), utf8);
	}
   	if( ! strcmp(firstopt, "access_log") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[13]), utf8);
	}
   	if( ! strcmp(firstopt, "cache_log") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[14]), utf8);
	}
   	if( ! strcmp(firstopt, "cache_store_log") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[15]), utf8);
	}
   	if( ! strcmp(firstopt, "pid_filename") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[16]), utf8);
	}
   	if( ! strcmp(firstopt, "hosts_file") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[17]), utf8);
	}
   	if( ! strcmp(firstopt, "icon_directory") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[18]), utf8);
	}
   	if( ! strcmp(firstopt, "error_directory") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[19]), utf8);
	}
   	if( ! strcmp(firstopt, "diskd_program") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[20]), utf8);
	}
   	if( ! strcmp(firstopt, "unlinkd_program") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[21]), utf8);
	}
   	if( ! strcmp(firstopt, "debug_options") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[22]), utf8);
	}
   	if( ! strcmp(firstopt, "ftp_user") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[23]), utf8);
	}
   	if( ! strcmp(firstopt, "uri_whitespace") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[24]), utf8);
	}
   	if( ! strcmp(firstopt, "cache_effective_user") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';
	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[25]), utf8);
	}
   	if( ! strcmp(firstopt, "cache_effective_group") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[26]), utf8);
	}
   	if( ! strcmp(firstopt, "cache_mgr") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[27]), utf8);
	}
   	if( ! strcmp(firstopt, "mail_program") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[28]), utf8);
	}
   	if( ! strcmp(firstopt, "umask") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[29]), utf8);
	}
   	if( ! strcmp(firstopt, "announce_host") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[30]), utf8);
	}
   	if( ! strcmp(firstopt, "as_whois_server") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[31]), utf8);
	}
   	if( ! strcmp(firstopt, "wccp_address") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[32]), utf8);
	}
   	if( ! strcmp(firstopt, "wccp2_address") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[33]), utf8);
	}
   	if( ! strcmp(firstopt, "wccp_router") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[34]), utf8);
	}
   	if( ! strcmp(firstopt, "store_dir_select_algorithm") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[35]), utf8);
	}
   	if( ! strcmp(firstopt, "coredump_dir") )
	{   
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' || new_buffer[strlen(new_buffer)-1]=='\r' )
	      new_buffer[strlen(new_buffer)-1]='\0';

	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[36]), utf8);
	}


/* Populate the spinbuttons, discard "minutes", "seconds" etc */
	if( ! strcmp(firstopt, "icp_query_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[0]), val);
	    }
	}
	if( ! strcmp(firstopt, "maximum_icp_query_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[1]), val);
	    }
	}
	if( ! strcmp(firstopt, "mcast_icp_query_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[2]), val);
	    }
	}
	if( ! strcmp(firstopt, "dead_peer_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    /* Skip everything efter the digits */
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[3]), val);
	    }
	}
	if( ! strcmp(firstopt, "forward_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[4]), val);
	    }
	}
	if( ! strcmp(firstopt, "connect_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[5]), val);
	    }
	}
	if( ! strcmp(firstopt, "peer_connect_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[6]), val);
	    }
	}
	if( ! strcmp(firstopt, "read_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[7]), val);
	    }
	}
	if( ! strcmp(firstopt, "request_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[8]), val);
	    }
	}
	if( ! strcmp(firstopt, "persistent_request_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[9]), val);
	    }
	}
	/* persistent connection timeout, pconn_timeout  */
	if( ! strcmp(firstopt, "pconn_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[10]), val);
	    }
	}
	if( ! strcmp(firstopt, "ident_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[11]), val);
	    }
	}
	if( ! strcmp(firstopt, "dns_timeout") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[12]), val);
	    }
	}
	if( ! strcmp(firstopt, "dns_retransmit_interval") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[13]), val);
	    }
	}
	if( ! strcmp(firstopt, "snmp_port") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[14]), val);
	    }
	}
	if( ! strcmp(firstopt, "cache_mem") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[15]), val);
	    }
	}
	if( ! strcmp(firstopt, "cache_swap_low") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[16]), val);
	    }
	}
	if( ! strcmp(firstopt, "cache_swap_high") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[17]), val);
	    }
	}
	if( ! strcmp(firstopt, "maximum_object_size") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[18]), val);
	    }
	}
	if( ! strcmp(firstopt, "minimum_object_size") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[19]), val);
	    }
	}
	if( ! strcmp(firstopt, "maximum_object_size_in_memory") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[20]), val);
	    }
	}
	if( ! strcmp(firstopt, "ipcache_size") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[21]), val);
	    }
	}
	if( ! strcmp(firstopt, "ipcache_low") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[22]), val);
	    }
	}
	if( ! strcmp(firstopt, "ipcache_high") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[23]), val);
	    }
	}
	if( ! strcmp(firstopt, "fqdncache_size") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[24]), val);
	    }
	}
	if( ! strcmp(firstopt, "ftp_list_width") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[25]), val);
	    }
	}
	if( ! strcmp(firstopt, "memory_pools_limit") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[26]), val);
	    }
	}
	if( ! strcmp(firstopt, "request_header_max_size") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[27]), val);
	    }
	}
	if( ! strcmp(firstopt, "request_body_max_size") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[28]), val);
	    }
	}
	if( ! strcmp(firstopt, "quick_abort_min") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[29]), val);
	    }
	}
	if( ! strcmp(firstopt, "quick_abort_max") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[30]), val);
	    }
	}
	if( ! strcmp(firstopt, "quick_abort_pct") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[31]), val);
	    }
	}
	if( ! strcmp(firstopt, "read_ahead_gap") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[32]), val);
	    }
	}
	if( ! strcmp(firstopt, "negative_ttl") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[33]), val);
	    }
	}
	if( ! strcmp(firstopt, "positive_dns_ttl") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[34]), val);
	    }
	}
	if( ! strcmp(firstopt, "negative_dns_ttl") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[35]), val);
	    }
	}
	if( ! strcmp(firstopt, "range_offset_limit") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[36]), val);
	    }
	}
	if( ! strcmp(firstopt, "client_lifetime") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[37]), val);
	    }
	}
	if( ! strcmp(firstopt, "shutdown_lifetime") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[38]), val);
	    }
	}
	if( ! strcmp(firstopt, "reply_header_max_size") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[39]), val);
	    }
	}
	if( ! strcmp(firstopt, "announce_period") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[40]), val);
	    }
	}
	if( ! strcmp(firstopt, "announce_port") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[41]), val);
	    }
	}
	if( ! strcmp(firstopt, "logfile_rotate") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[42]), val);
	    }
	}
	if( ! strcmp(firstopt, "tcp_recv_bufsize") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[43]), val);
	    }
	}
	if( ! strcmp(firstopt, "minimum_direct_hops") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[44]), val);
	    }
	}
	if( ! strcmp(firstopt, "minimum_direct_rtt") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[45]), val);
	    }
	}
	if( ! strcmp(firstopt, "store_avg_object_size") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[46]), val);
	    }
	}
	if( ! strcmp(firstopt, "store_objects_per_bucket") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[47]), val);
	    }
	}
	if( ! strcmp(firstopt, "netdb_low") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[48]), val);
	    }
	}
	if( ! strcmp(firstopt, "netdb_high") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[49]), val);
	    }
	}
	if( ! strcmp(firstopt, "netdb_ping_period") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[50]), val);
	    }
	}
	if( ! strcmp(firstopt, "maximum_single_addr_tries") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[51]), val);
	    }
	}
	if( ! strcmp(firstopt, "wccp_version") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[52]), val);
	    }
	}
	if( ! strcmp(firstopt, "wccp2_forwarding_method") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[53]), val);
	    }
	}
	if( ! strcmp(firstopt, "wccp2_return_method") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[54]), val);
	    }
	}
	if( ! strcmp(firstopt, "wccp2_assignment_method") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[55]), val);
	    }
	}
	if( ! strcmp(firstopt, "wccp2_service") ) // FIXME: "wccp2_service standard/dynamic 2" Entry ?
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[56]), val);
	    }
	}
	if( ! strcmp(firstopt, "wccp2_weight") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[57]), val);
	    }
	}
/*
	if( ! strcmp(firstopt, "incoming_icp_average") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[58]), val);
	    }
	}
	if( ! strcmp(firstopt, "incoming_http_average") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[59]), val);
	    }
	}
	if( ! strcmp(firstopt, "incoming_dns_average") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[60]), val);
	    }
	}
	if( ! strcmp(firstopt, "min_icp_poll_cnt") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[61]), val);
	    }
	}
	if( ! strcmp(firstopt, "min_dns_poll_cnt") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[62]), val);
	    }
	}
	if( ! strcmp(firstopt, "min_http_poll_cnt") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[63]), val);
	    }
	}
*/
	if( ! strcmp(firstopt, "max_open_disk_fds") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[64]), val);
	    }
	}
	if( ! strcmp(firstopt, "digest_bits_per_entry") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[65]), val);
	    }
	}
	if( ! strcmp(firstopt, "digest_rebuild_period") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[66]), val);
	    }
	}
	if( ! strcmp(firstopt, "digest_rewrite_period") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[67]), val);
	    }
	}
	if( ! strcmp(firstopt, "digest_swapout_chunk_size") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[68]), val);
	    }
	}
	if( ! strcmp(firstopt, "digest_rebuild_chunk_percentage") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[69]), val);
	    }
	}
	if( ! strcmp(firstopt, "high_response_time_warning") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[70]), val);
	    }
	}
	if( ! strcmp(firstopt, "high_page_fault_warning") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[71]), val);
	    }
	}
	if( ! strcmp(firstopt, "high_memory_warning") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[72]), val);
	    }
	}
	if( ! strcmp(firstopt, "sleep_after_fork") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[73]), val);
	    }
	}
	if( ! strcmp(firstopt, "minimum_expiry_time") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[74]), val);
	    }
	}
	if( ! strcmp(firstopt, "authenticate_cache_garbage_interval") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[75]), val);
	    }
	}
	if( ! strcmp(firstopt, "authenticate_ttl") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[76]), val);
	    }
	}
	if( ! strcmp(firstopt, "authenticate_ip_ttl") )
	{
	    opt_pos = get_option_pos(line, 1);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==' ' )
	        break;
	    new_buffer[i]='\0';
	    if( chars_are_digits(new_buffer) )
	    {
        	val = atoi(new_buffer);
        	gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[77]), val);
	    }
	}



/* Populate combos */
	if( ! strcmp(firstopt, "check_hostnames") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 1);
	}
	if( ! strcmp(firstopt, "dns_defnames") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 1);
	}
	if( ! strcmp(firstopt, "emulate_httpd_log") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[2]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[2]), 1);
	}
	if( ! strcmp(firstopt, "log_ip_on_direct") )
	{
	    if( cmplowercase(line, "on") && ! cmplowercase(line, "off") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 1);
	}
	if( ! strcmp(firstopt, "log_mime_hdrs") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[4]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[4]), 1);
	}
	if( ! strcmp(firstopt, "log_fqdn") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[5]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[5]), 1);
	}
	if( ! strcmp(firstopt, "ftp_passive") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[6]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[6]), 1);
	}
	if( ! strcmp(firstopt, "ftp_sanitycheck") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[7]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[7]), 1);
	}
	if( ! strcmp(firstopt, "ftp_telnet_protocol") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[8]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[8]), 1);
	}
	if( ! strcmp(firstopt, "allow_underscore") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[9]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[9]), 1);
	}
	if( ! strcmp(firstopt, "memory_pools") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[10]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[10]), 1);
	}
	if( ! strcmp(firstopt, "half_closed_clients") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[11]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[11]), 1);
	}
	if( ! strcmp(firstopt, "httpd_suppress_version_string") )
	{
	    if( cmplowercase(line, "on") && ! cmplowercase(line, "off") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[12]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[12]), 1);
	}
	if( ! strcmp(firstopt, "via") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[13]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[13]), 1);
	}
	if( ! strcmp(firstopt, "forwarded_for") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[14]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[14]), 1);
	}
	if( ! strcmp(firstopt, "log_icp_queries") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[15]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[15]), 1);
	}
	if( ! strcmp(firstopt, "client_db") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[16]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[16]), 1);
	}
	if( ! strcmp(firstopt, "icp_hit_stale") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[17]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[17]), 1);
	}
	if( ! strcmp(firstopt, "query_icmp") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[18]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[18]), 1);
	}
	if( ! strcmp(firstopt, "test_reachability") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[19]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[19]), 1);
	}
	if( ! strcmp(firstopt, "buffered_logs") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[20]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[20]), 1);
	}
	if( ! strcmp(firstopt, "reload_into_ims") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[21]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[21]), 1);
	}
	if( ! strcmp(firstopt, "global_internal_static") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[22]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[22]), 1);
	}
	if( ! strcmp(firstopt, "short_icon_urls") )
	{
	    if( cmplowercase(line, "on") && ! cmplowercase(line, "off") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[23]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[23]), 1);
	}
	if( ! strcmp(firstopt, "offline_mode") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[24]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[24]), 1);
	}
	if( ! strcmp(firstopt, "nonhierarchical_direct") )
	{
	    if( cmplowercase(line, "on") && ! cmplowercase(line, "off") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[25]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[25]), 1);
	}
	if( ! strcmp(firstopt, "prefer_direct") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[26]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[26]), 1);
	}
	if( ! strcmp(firstopt, "strip_query_terms") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[27]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[27]), 1);
	}
	if( ! strcmp(firstopt, "redirector_bypass") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[28]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[28]), 1);
	}
	if( ! strcmp(firstopt, "ignore_unknown_nameservers") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[29]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[29]), 1);
	}
	if( ! strcmp(firstopt, "client_persistent_connections") )
	{
	    if( cmplowercase(line, "on") && ! cmplowercase(line, "off") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[30]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[30]), 1);
	}
	if( ! strcmp(firstopt, "server_persistent_connections") )
	{
	    if( cmplowercase(line, "on") && ! cmplowercase(line, "off") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[31]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[31]), 1);
	}
	if( ! strcmp(firstopt, "persistent_connection_after_error") )
	{
	    if( cmplowercase(line, "on") && ! cmplowercase(line, "off") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[32]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[32]), 1);
	}
	if( ! strcmp(firstopt, "detect_broken_pconn") )
	{
	    if( cmplowercase(line, "on") && ! cmplowercase(line, "off") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[33]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[33]), 1);
	}
	if( ! strcmp(firstopt, "balance_on_multiple_ip") )
	{
	    if( cmplowercase(line, "on") && ! cmplowercase(line, "off") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[34]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[34]), 1);
	}
	if( ! strcmp(firstopt, "pipeline_prefetch") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[35]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[35]), 1);
	}
	if( ! strcmp(firstopt, "request_entities") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[36]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[36]), 1);
	}
	if( ! strcmp(firstopt, "ie_refresh") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[37]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[37]), 1);
	}
	if( ! strcmp(firstopt, "vary_ignore_expire") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[38]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[38]), 1);
	}
	if( ! strcmp(firstopt, "relaxed_header_parser") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[39]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[39]), 1);
	}
	if( ! strcmp(firstopt, "retry_on_error") )
	{
	    if( cmplowercase(line, "on") && ! cmplowercase(line, "off") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[40]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[40]), 1);
	}
	if( ! strcmp(firstopt, "wccp2_rebuild_wait") )
	{
	    if( cmplowercase(line, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[41]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[41]), 1);
	}
	if( ! strcmp(firstopt, "digest_generation") )
	{
	    if( cmplowercase(line, "on") && ! cmplowercase(line, "off") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[42]), 0);
	    else
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[42]), 1);
	}


	free(firstopt);
    }
    fclose(fp);
    free(line);
    free(new_buffer);

    if( utf8!=NULL )
      g_free(utf8);

    gtk_widget_show_all(widgets->main_window);
}
