// ---------------------------------------------------------------------
// $Id: gaffitter.cc,v 1.13 2006/08/11 14:44:01 daaugusto Exp $
//
//   gaffitter.cc (created on Tue Aug 23 01:08:35 BRT 2005)
// 
//   Genetic Algorithm File Fitter (gaffitter)
//
//   Copyright (C) 2005-2006 Douglas A. Augusto
// 
// This file is part of gaffitter.
// 
// gaffitter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.
// 
// gaffitter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with gaffitter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// ---------------------------------------------------------------------

#include "Optimizer.hh"
#include "optimizers/GeneticAlgorithm.hh"
#include "optimizers/BruteForce.hh"
#include "optimizers/BestFirst.hh"
#include "optimizers/Split.hh"

#include "Params.hh"
#include "Input.hh"
#include "util/Exception.hh"

//----------------------------------------------------------------------
int main(int argc, char** argv) 
{
   try {
      // read the options
      Params parameters(argc,argv);

      // just ShowUsage()?
      if (!parameters.Initialize()) return 0;

      // read filenames
      Input input(parameters);
      input.Initialize();

      Optimizer* gaffitter = 0;

      try {
         // create the GA optimizer
         if (parameters.m_approximate)
            gaffitter = new BestFirst(input.m_files,parameters);
         else if (parameters.m_brute_force)
            gaffitter = new BruteForce(input.m_files,parameters);
         else if (parameters.m_split)
            gaffitter = new Split(input.m_files,parameters);
         else
            gaffitter = new GeneticAlgorithm(input.m_files,parameters);

         // evolve
         do { gaffitter->Evolve(); } while (gaffitter->Output());
      }
      catch(...) {
         delete gaffitter;
         throw;
      }

      delete gaffitter;
   }
   catch (E_Exception& e) 
   {
      std::cerr << e;
      return 1;
   } 
   catch (const std::exception& e)
   {
      std::cerr << '\n' << "> Error: " << e.what() << std::endl;
      return 1;
   }
   catch (...) {
      std::cerr << '\n' << "> Error: " << "An unknown error occurred." 
         << std::endl;
      return 1;
   }

   return 0;
}
