// ---------------------------------------------------------------------
// $Id: BruteForce.hh,v 1.11 2007/03/28 09:47:10 daaugusto Exp $
//
//   BruteForce.hh (created on Fri Nov 18 20:47:35 BRT 2005)
// 
//   Genetic Algorithm File Fitter (gaffitter)
//
//   Copyright (C) 2005-2007 Douglas A. Augusto
// 
// This file is part of gaffitter.
// 
// gaffitter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.
// 
// gaffitter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with gaffitter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// ---------------------------------------------------------------------

#ifndef BruteForce_hh
#define BruteForce_hh

#include "../Optimizer.hh"

using namespace std;

// ---------------------------------------------------------------------
/**
 * Optimization via the Brute Force search.
 */
class BruteForce: public Optimizer {
public:
   /**
    * Calls the base constructor and print some information if needed.
    */
   BruteForce(vector<SizeName>& sn, Params& p):Optimizer(sn,p) {}
   /** 
    * "Evolve" via Brute Force search.
    *
    * This search algorithm tries all possible combinations. Exponential
    * complexity (2^n, where n=|input|). This algorithm produces
    * guaranteed globally optimal solutions, but it becomes very very slow
    * when 'n' grows. Uses carefully!
    */
   void Evolve();

protected:
   /** 
    * Writes some information (like algorithm name and parameters) in
    * ostream object (usually cout).
    */
   ostream& Write(ostream& s) const;
};

// ---------------------------------------------------------------------

#endif
