 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Project: gafix                                                         *
 * File: text_functions.c                                                 *
 * Copyright: (c) 2007 Sebastian Reichel                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This program is free software; you can redistribute it and/or modidy   *
 * it under the terms of GNU Public License as published by               *
 * the Free Software Foundation; either version 2 of the License, or      *
 * (at your option) any later version.                                    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <gtksourceview/gtksourcebuffer.h>
#include <gtksourceview/gtksourcetagtable.h>
#include "gafix.h"
#include "tab.h"
#include "statusbar.h"

void
text_delete ()
{
	GtkTextBuffer *textbuffer = NULL;

	statusbar_write ("Delete selcted text");
	
	/* get tab's text-buffer */
	textbuffer = GTK_TEXT_BUFFER ( get_buffer_of_tab ( gtk_notebook_get_current_page( GTK_NOTEBOOK(notebook) ) ) );
  
	/* delete selected code */
	gtk_text_buffer_delete_selection (textbuffer, TRUE, TRUE);
}

void
text_cut ()
{
	GtkTextBuffer *textbuffer = NULL;

	statusbar_write ("Cut to clipboard");
	
	/* get tab's text-buffer */
	textbuffer = GTK_TEXT_BUFFER ( get_buffer_of_tab ( gtk_notebook_get_current_page( GTK_NOTEBOOK(notebook) ) ) );
  
	/* cut text and put it into the clipboard */
	gtk_text_buffer_cut_clipboard (textbuffer, gtk_clipboard_get (GDK_NONE), TRUE);
}

void
text_copy ()
{
	GtkTextBuffer *textbuffer = NULL;

	statusbar_write ("Copy to clipboard");
	
	/* get tab's text-buffer */
	textbuffer = GTK_TEXT_BUFFER ( get_buffer_of_tab ( gtk_notebook_get_current_page( GTK_NOTEBOOK(notebook) ) ) );
	
	/* copy text and put it into the clipboard */
	gtk_text_buffer_copy_clipboard (textbuffer, gtk_clipboard_get (GDK_NONE));
}

void
text_paste()
{
	GtkTextBuffer *textbuffer = NULL;

	statusbar_write ("Insert into clipboard");
	
	/* get tab's text-buffer */
	textbuffer = GTK_TEXT_BUFFER ( get_buffer_of_tab ( gtk_notebook_get_current_page( GTK_NOTEBOOK(notebook) ) ) );
  
	/* insert text from the clipboard into the buffer */
	gtk_text_buffer_paste_clipboard (textbuffer, gtk_clipboard_get (GDK_NONE), NULL, TRUE);
}

void
text_undo ()
{
	GtkSourceBuffer *textbuffer = NULL;
	
	statusbar_write ("Undo the last step");
	
	/* get tab's text-buffer */
	textbuffer = GTK_SOURCE_BUFFER ( get_buffer_of_tab ( gtk_notebook_get_current_page( GTK_NOTEBOOK(notebook) ) ) );

	/* undo the last step */
	gtk_source_buffer_undo (textbuffer);
}

void
text_redo ()
{
	GtkSourceBuffer *textbuffer = NULL;
	
	statusbar_write ("Redo the last step");
	
	/* get tab's text-buffer */
	textbuffer = GTK_SOURCE_BUFFER ( get_buffer_of_tab ( gtk_notebook_get_current_page( GTK_NOTEBOOK(notebook) ) ) );

	/* redo the last step */
	gtk_source_buffer_redo (textbuffer);
}
